/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.YearMonthCalendarDemoView;
import com.flowingcode.addons.ycalendar.YearMonthField;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.List;
import java.util.Optional;

@DemoSource
@PageTitle(value="Year-Month Field")
@Route(value="year-month-calendar/year-month-field", layout=YearMonthCalendarDemoView.class)
public class YearMonthFieldDemo
extends Div {
    private static final String FRENCH = "French";
    private static final String SPANISH = "Spanish";
    private static final String ENGLISH = "English";

    public YearMonthFieldDemo() {
        YearMonthField field = new YearMonthField();
        this.add(new Component[]{field});
        RadioButtonGroup languageSelector = new RadioButtonGroup("Choose language:");
        languageSelector.setItems((Object[])new String[]{ENGLISH, SPANISH, FRENCH});
        languageSelector.setValue((Object)ENGLISH);
        languageSelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
            switch ((String)e.getValue()) {
                case "Spanish": {
                    i18n.setMonthNames(List.of("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"));
                    break;
                }
                case "French": {
                    i18n.setMonthNames(List.of("janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre"));
                    break;
                }
            }
            field.setI18n(i18n);
        });
        this.add(new Component[]{languageSelector});
        Span minRangeValue = new Span("-");
        Span maxRangeValue = new Span("-");
        this.add(new Component[]{new Div(new Component[]{new Text("Min: "), minRangeValue, new Text(" :: Max: "), maxRangeValue})});
        YearMonth min = YearMonth.now().minusYears(2L);
        Button setMinRangeButton = new Button("Set min " + min.toString());
        setMinRangeButton.addClickListener((ComponentEventListener & Serializable)e -> {
            field.setMin(min);
            minRangeValue.setText(Optional.ofNullable(field.getMin()).map(YearMonth::toString).orElse("-"));
        });
        YearMonth max = YearMonth.now().plusYears(2L);
        Button setMaxRangeButton = new Button("Set max " + max.toString());
        setMaxRangeButton.addClickListener((ComponentEventListener & Serializable)e -> {
            field.setMax(max);
            maxRangeValue.setText(Optional.ofNullable(field.getMax()).map(YearMonth::toString).orElse("-"));
        });
        Button clearRangeButton = new Button("Clear range");
        clearRangeButton.addClickListener((ComponentEventListener & Serializable)e -> {
            field.setMin(null);
            field.setMax(null);
            minRangeValue.setText("-");
            maxRangeValue.setText("-");
        });
        YearMonth newValue = YearMonth.now().plusYears(3L);
        Button setValueButton = new Button("Set value " + newValue.toString());
        setValueButton.addClickListener((ComponentEventListener & Serializable)e -> field.setValue((Object)newValue));
        this.add(new Component[]{new HorizontalLayout(new Component[]{setMinRangeButton, setMaxRangeButton, clearRangeButton, setValueButton})});
    }
}

