/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.Locale;

public class LocaleSelector
extends Composite<RadioButtonGroup<Locale>> {
    private final SerializableConsumer<DatePicker.DatePickerI18n> consumer;

    public LocaleSelector(SerializableConsumer<DatePicker.DatePickerI18n> consumer) {
        this.consumer = consumer;
        ((RadioButtonGroup)this.getContent()).addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.updateLocale((Locale)ev.getValue()));
        ((RadioButtonGroup)this.getContent()).setItems((Object[])new Locale[]{Locale.ENGLISH, Locale.GERMAN, new Locale("es")});
        ((RadioButtonGroup)this.getContent()).setItemLabelGenerator((ItemLabelGenerator & Serializable)locale -> locale.getDisplayLanguage(Locale.ENGLISH));
        ((RadioButtonGroup)this.getContent()).setLabel("Choose Language");
        ((RadioButtonGroup)this.getContent()).setValue((Object)Locale.ENGLISH);
    }

    private void updateLocale(Locale locale) {
        DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        i18n.setMonthNames(List.of(dfs.getMonths()));
        i18n.setWeekdays(List.of(dfs.getWeekdays()).stream().skip(1L).toList());
        i18n.setWeekdaysShort(List.of(dfs.getShortWeekdays()).stream().skip(1L).toList());
        DayOfWeek firstDayOfWeek = WeekFields.of(locale).getFirstDayOfWeek();
        i18n.setFirstDayOfWeek(firstDayOfWeek.getValue() % 7);
        this.consumer.accept((Object)i18n);
    }
}

