/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.AbstractCalendarComponent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

@Tag(value="fc-month-calendar")
@JsModule.Container(value={@JsModule(value="./fc-month-calendar/month-calendar-mixin.js"), @JsModule(value="./fc-month-calendar/fc-month-calendar.js")})
@NpmPackage(value="@polymer/iron-a11y-keys-behavior", version="3.0.1")
@Uses(value=DatePicker.class)
public class MonthCalendar
extends AbstractCalendarComponent<MonthCalendar>
implements HasSize,
HasTheme {
    private YearMonth yearMonth;
    private ValueProvider<LocalDate, String> classNameGenerator;

    public MonthCalendar(int year, Month month) {
        this(YearMonth.of(year, month));
    }

    public MonthCalendar(YearMonth yearMonth) {
        this.setYearMonth(yearMonth);
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setAttribute("readonly", readOnly);
    }

    public YearMonth getYearMonth() {
        return this.yearMonth;
    }

    public Month getMonth() {
        return this.yearMonth.getMonth();
    }

    public void setYearMonth(YearMonth yearMonth) {
        this.yearMonth = Objects.requireNonNull(yearMonth);
        this.yearMonth = Objects.requireNonNull(yearMonth);
        String script = "this.month=new Date($0,$1-1,1);";
        this.getElement().executeJs(script, new Serializable[]{Integer.valueOf(yearMonth.getYear()), Integer.valueOf(yearMonth.getMonthValue())});
        this.refreshAll();
    }

    public void setClassNameGenerator(ValueProvider<LocalDate, String> classNameGenerator) {
        this.classNameGenerator = classNameGenerator;
        this.refreshAll();
    }

    @Override
    public void refreshAll() {
        IntStream.rangeClosed(1, this.yearMonth.lengthOfMonth()).mapToObj(this.yearMonth::atDay).forEach(this::refreshItem);
        this.getElement().executeJs("setTimeout(()=>this._clearEmptyDaysStyle())", new Serializable[0]);
    }

    public void refreshItem(LocalDate date) {
        if (date.getYear() != this.yearMonth.getYear() || date.getMonth() != this.yearMonth.getMonth()) {
            throw new IllegalArgumentException();
        }
        String className = Optional.ofNullable(this.classNameGenerator).map(g -> (String)g.apply((Object)date)).orElse(null);
        this.getElement().executeJs("setTimeout(()=>{this._setStyleForDay($0,$1);})", new Serializable[]{Integer.valueOf(date.getDayOfMonth()), className});
    }
}

