/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.MonthCalendar;
import com.flowingcode.addons.ycalendar.YearMonthField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

@Tag(value="fc-inline-date-picker")
@JsModule(value="./fc-inline-date-picker/fc-inline-date-picker.js")
@Uses.Container(value={@Uses(value=YearMonthField.class), @Uses(value=MonthCalendar.class)})
public class InlineDatePicker
extends AbstractSinglePropertyField<InlineDatePicker, LocalDate>
implements HasSize,
HasTheme {
    private static final String VALUE_PROPERTY = "value";
    private ValueProvider<LocalDate, String> classNameGenerator;
    private YearMonth yearMonth;

    private static <R, S> SerializableFunction<R, S> map(SerializableFunction<R, S> f) {
        return (SerializableFunction & Serializable)r -> Optional.ofNullable(r).map(f).orElse(null);
    }

    public InlineDatePicker() {
        super(VALUE_PROPERTY, null, String.class, InlineDatePicker.map(LocalDate::parse), InlineDatePicker.map(LocalDate::toString));
        this.setValue(LocalDate.now());
        this.setWeekNumbersVisible(true);
        this.getElement().addEventListener("month-change", (DomEventListener & Serializable)event -> this.setYearMonth(YearMonth.parse(event.getEventData().getString("event.detail.value")))).addEventData("event.detail.value");
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.getElement().setProperty("showWeekNumbers", weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.getElement().getProperty("showWeekNumbers", false);
    }

    public void setI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)i18n));
    }

    public void setClassNameGenerator(ValueProvider<LocalDate, String> classNameGenerator) {
        this.classNameGenerator = classNameGenerator;
        this.refreshAll();
    }

    public void refreshAll() {
        IntStream.rangeClosed(1, this.yearMonth.lengthOfMonth()).mapToObj(this.yearMonth::atDay).forEach(this::refreshItem);
        this.getElement().executeJs("setTimeout(()=>this._clearEmptyDaysStyle())", new Serializable[0]);
    }

    public void refreshItem(LocalDate date) {
        if (date.getYear() == this.yearMonth.getYear() && date.getMonth() == this.yearMonth.getMonth()) {
            String className = Optional.ofNullable(this.classNameGenerator).map(g -> (String)g.apply((Object)date)).orElse(null);
            this.getElement().executeJs("setTimeout(()=>{this._setStyleForDay($0,$1);})", new Serializable[]{Integer.valueOf(date.getDayOfMonth()), className});
        }
    }

    public void setValue(LocalDate value) {
        Objects.requireNonNull(value);
        super.setValue((Object)value);
        this.setYearMonth(YearMonth.from(value));
    }

    private void setYearMonth(YearMonth value) {
        Objects.requireNonNull(value);
        if (!value.equals(this.yearMonth)) {
            this.yearMonth = value;
            this.refreshAll();
        }
    }
}

