/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import elemental.json.Json;
import elemental.json.JsonNull;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;

@Tag(value="fc-year-month-field")
@JsModule(value="./fc-year-month-field/fc-year-month-field.js")
public class YearMonthField
extends AbstractSinglePropertyField<YearMonthField, YearMonth>
implements HasTheme {
    private static final String VALUE_PROPERTY = "value";
    private YearMonth max;
    private YearMonth min;

    private static <R, S> SerializableFunction<R, S> map(SerializableFunction<R, S> f) {
        return (SerializableFunction & Serializable)r -> Optional.ofNullable(r).map(f).orElse(null);
    }

    public <P> YearMonthField() {
        super(VALUE_PROPERTY, null, String.class, YearMonthField.map(YearMonth::parse), YearMonthField.map(YearMonth::toString));
        this.setValue(YearMonth.now());
    }

    public void setI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)i18n));
    }

    public void setMin(YearMonth min) {
        JsonNull value = min == null ? Json.createNull() : Json.parse((String)("{'month': " + min.getMonth().ordinal() + ", 'year': " + min.getYear() + "}"));
        this.getElement().setPropertyJson("min", (JsonValue)value);
        this.min = min;
    }

    public YearMonth getMin() {
        return this.min;
    }

    public void setMax(YearMonth max) {
        JsonNull value = max == null ? Json.createNull() : Json.parse((String)("{'month': " + max.getMonth().ordinal() + ", 'year': " + max.getYear() + "}"));
        this.getElement().setPropertyJson("max", (JsonValue)value);
        this.max = max;
    }

    public YearMonth getMax() {
        return this.max;
    }
}

