/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.YearCalendar;
import com.flowingcode.addons.ycalendar.YearMonthCalendarDemoView;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.Locale;

@CssImport(value="./styles/test_year-month-calendar.css", themeFor="vaadin-month-calendar")
@PageTitle(value="i18n")
@DemoSource
@Route(value="year-month-calendar/year-i18n", layout=YearMonthCalendarDemoView.class)
public class YearI18NDemo
extends Div {
    public YearI18NDemo() {
        Locale locale = Locale.GERMAN;
        DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        i18n.setMonthNames(List.of(dfs.getMonths()));
        i18n.setWeekdays(List.of(dfs.getWeekdays()).stream().skip(1L).toList());
        i18n.setWeekdaysShort(List.of(dfs.getShortWeekdays()).stream().skip(1L).toList());
        DayOfWeek firstDayOfWeek = WeekFields.of(locale).getFirstDayOfWeek();
        i18n.setFirstDayOfWeek(firstDayOfWeek.getValue() % 7);
        YearCalendar calendar = new YearCalendar();
        calendar.setClassNameGenerator((ValueProvider & Serializable)date -> {
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return "weekend";
            }
            return null;
        });
        calendar.setI18n(i18n);
        this.add(new Component[]{calendar});
    }
}

