/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.LocaleSelector;
import com.flowingcode.addons.ycalendar.TestUtils;
import com.flowingcode.addons.ycalendar.YearCalendar;
import com.flowingcode.addons.ycalendar.YearMonthCalendarDemoView;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.DayOfWeek;

@DemoSource
@PageTitle(value="YearCalendar")
@CssImport(value="./styles/test_year-month-calendar.css", themeFor="vaadin-month-calendar")
@Route(value="year-month-calendar/year", layout=YearMonthCalendarDemoView.class)
public class YearDemo
extends Div {
    private static final Method setHasControlsMethod = TestUtils.getMethod(IntegerField.class, "setHasControls", Boolean.TYPE).orElse(null);
    private static final Method setStepButtonsVisibleMethod = TestUtils.getMethod(IntegerField.class, "setStepButtonsVisible", Boolean.TYPE).orElse(null);

    public YearDemo() {
        this.addClassName("year-demo");
        YearCalendar calendar = new YearCalendar();
        calendar.setClassNameGenerator((ValueProvider & Serializable)date -> {
            if (TestUtils.isPublicHoliday(date)) {
                return "holiday";
            }
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return "weekend";
            }
            return null;
        });
        calendar.addYearChangedListener((ComponentEventListener & Serializable)e -> Notification.show((String)("Year " + e.getYear() + " selected")));
        Span selectedDate = new Span();
        calendar.addDateSelectedListener((ComponentEventListener & Serializable)ev -> selectedDate.setText("Selected date: " + ev.getDate()));
        Span instructions = new Span("Use arrow keys or Ctrl+arrow keys to move.");
        IntegerField yearField = new IntegerField();
        try {
            if (setHasControlsMethod != null) {
                setHasControlsMethod.invoke((Object)yearField, true);
            } else if (setStepButtonsVisibleMethod != null) {
                setStepButtonsVisibleMethod.invoke((Object)yearField, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        yearField.setValue((Number)calendar.getYear());
        yearField.setLabel("Change year");
        yearField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> calendar.setYear(((Integer)e.getValue()).intValue()));
        LocaleSelector localeSelector = new LocaleSelector((SerializableConsumer<DatePicker.DatePickerI18n>)((SerializableConsumer & Serializable)arg_0 -> ((YearCalendar)calendar).setI18n(arg_0)));
        HorizontalLayout controls = new HorizontalLayout(new Component[]{yearField, localeSelector});
        controls.setSpacing(true);
        controls.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.add(new Component[]{new HorizontalLayout(new Component[]{instructions, selectedDate}), controls});
        this.add(new Component[]{calendar});
    }
}

