/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.ycalendar;

import com.flowingcode.addons.ycalendar.MonthCalendar;
import com.flowingcode.addons.ycalendar.TestUtils;
import com.flowingcode.addons.ycalendar.YearMonthCalendarDemoView;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.YearMonth;

@DemoSource
@PageTitle(value="Month")
@CssImport(value="./styles/test_year-month-calendar.css", themeFor="vaadin-month-calendar")
@Route(value="year-month-calendar/month", layout=YearMonthCalendarDemoView.class)
public class MonthDemo
extends Div {
    public MonthDemo() {
        MonthCalendar calendar = new MonthCalendar(YearMonth.now());
        calendar.setClassNameGenerator((ValueProvider & Serializable)date -> {
            if (TestUtils.isPublicHoliday(date)) {
                return "holiday";
            }
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return "weekend";
            }
            return null;
        });
        Span selectedDate = new Span();
        calendar.addDateSelectedListener((ComponentEventListener & Serializable)ev -> selectedDate.setText("Selected date: " + ev.getDate()));
        Span instructions = new Span("Use arrow keys to move.");
        this.add(new Component[]{new HorizontalLayout(new Component[]{instructions, selectedDate}), calendar});
    }
}

