/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.whatsappbutton;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.whatsappbutton.WhatsappButton;
import com.flowingcode.vaadin.addons.whatsappbutton.WhatsappButtonDemoView;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import java.io.Serializable;

@DemoSource
@PageTitle(value="Whatsapp Button")
@Route(value="whatsappbutton/whatsappbutton", layout=WhatsappButtonDemoView.class)
public class WhatsappButtonDemo
extends Div {
    private Checkbox redirect;

    public WhatsappButtonDemo() {
        WhatsappButton whatsappButton = new WhatsappButton();
        Div buttonContainer = new Div();
        buttonContainer.setClassName("centered button-container");
        buttonContainer.add(new Component[]{whatsappButton});
        this.add(new Component[]{buttonContainer});
        TextField label = this.createTextField("Enter a label for the button");
        label.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setLabel((String)e.getValue()));
        TextArea text = new TextArea();
        text.setPlaceholder("Enter a text message");
        text.setWidthFull();
        text.setClearButtonVisible(true);
        text.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setText((String)e.getValue()));
        FlexLayout phoneLayout = new FlexLayout();
        phoneLayout.setWidthFull();
        IntegerField dialCode = this.createIntegerField("Code");
        dialCode.addClassName("dialcode");
        dialCode.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setDialCode(e.getValue() != null ? String.valueOf(e.getValue()) : ""));
        IntegerField phone = this.createIntegerField("Phone number");
        phone.addClassName("phone");
        phone.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setPhone(e.getValue() != null ? String.valueOf(e.getValue()) : ""));
        phoneLayout.add(new Component[]{dialCode, phone});
        phoneLayout.expand(new Component[]{phone});
        TextField inviteCode = this.createTextField("Enter a invite code");
        inviteCode.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setInviteCode((String)e.getValue()));
        FormLayout formLayout = new FormLayout();
        formLayout.addClassName("centered");
        formLayout.addFormItem((Component)label, "Label");
        formLayout.addFormItem((Component)text, "Message Text");
        formLayout.addFormItem((Component)phoneLayout, "Phone");
        formLayout.addFormItem((Component)inviteCode, "Invite Code");
        this.add(new Component[]{formLayout});
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1), new FormLayout.ResponsiveStep("900px", 2)});
        Checkbox leadingIcon = new Checkbox();
        leadingIcon.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setLeadingIcon(((Boolean)e.getValue()).booleanValue()));
        this.redirect = new Checkbox();
        this.redirect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setRedirect(((Boolean)e.getValue()).booleanValue()));
        Checkbox responsive = new Checkbox();
        responsive.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setResponsive(((Boolean)e.getValue()).booleanValue()));
        Checkbox dialog = new Checkbox();
        dialog.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> whatsappButton.setShowDialog(((Boolean)e.getValue()).booleanValue()));
        FormLayout checksLayout = new FormLayout();
        checksLayout.addClassName("centered");
        checksLayout.addFormItem((Component)leadingIcon, "Leading Icon");
        checksLayout.addFormItem((Component)this.redirect, "Redirect");
        checksLayout.addFormItem((Component)responsive, "Responsive");
        checksLayout.addFormItem((Component)dialog, "Dialog");
        this.add(new Component[]{checksLayout});
    }

    private TextField createTextField(String placeholder) {
        TextField textField = new TextField();
        textField.setPlaceholder(placeholder);
        textField.setWidthFull();
        textField.setClearButtonVisible(true);
        return textField;
    }

    private IntegerField createIntegerField(String placeholder) {
        IntegerField integerField = new IntegerField();
        integerField.setPlaceholder(placeholder);
        integerField.setClearButtonVisible(true);
        integerField.setValueChangeMode(ValueChangeMode.ON_BLUR);
        return integerField;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initializeRedirect();
    }

    private void initializeRedirect() {
        UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
            WebBrowser webBrowser = VaadinSession.getCurrent().getBrowser();
            boolean isMobile = webBrowser != null && (webBrowser.isAndroid() || webBrowser.isIPhone() || webBrowser.isWindowsPhone() || details.isIPad());
            this.redirect.setValue((Object)(!isMobile ? 1 : 0));
        });
    }
}

