/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.wcstories;

import com.flowingcode.vaadin.addons.wcstories.WCStoriesStory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import java.util.List;
import java.util.stream.Collectors;

@Tag(value="wc-stories")
@NpmPackage.Container(value={@NpmPackage(value="web-animations-js", version="2.3.2"), @NpmPackage(value="@gugadev/wc-stories", version="1.0.0"), @NpmPackage(value="custom-elements-native-shim", version="1.0.0")})
@JsModule.Container(value={@JsModule(value="web-animations-js/web-animations.min.js"), @JsModule(value="./storify/dist/index.js")})
public class WCStories
extends Component
implements HasComponents {
    public WCStories(List<String> storiesPaths) {
        List<WCStoriesStory> stories = this.generateStoriesItems(storiesPaths);
        this.setStories(stories);
    }

    private List<WCStoriesStory> generateStoriesItems(List<String> storiesPaths) {
        return storiesPaths.stream().map(WCStoriesStory::new).collect(Collectors.toList());
    }

    public void setRadius(Integer radius) {
        if (radius != null) {
            this.getElement().setAttribute("radius", String.valueOf(radius));
        }
    }

    public void setStartAt(Integer startAt) {
        if (startAt != null) {
            this.getElement().setAttribute("startAt", String.valueOf(startAt));
        }
    }

    public void setDuration(Integer duration) {
        if (duration != null) {
            this.getElement().setAttribute("duration", String.valueOf(duration));
        }
    }

    public void setHeight(Integer height) {
        if (height != null) {
            this.getElement().setAttribute("height", String.valueOf(height));
        }
    }

    public void setWidth(Integer width) {
        if (width != null) {
            this.getElement().setAttribute("width", String.valueOf(width));
        }
    }

    public void setWithShadow(Boolean withShadow) {
        if (withShadow != null) {
            this.getElement().setAttribute("withShadow", withShadow.booleanValue());
        }
    }

    public void setStories(List<WCStoriesStory> stories) {
        for (int i = 0; i < stories.size(); ++i) {
            this.addComponentAtIndex(i, stories.get(i));
        }
    }
}

