/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.SourceCodeViewer;
import com.flowingcode.vaadin.addons.shareeasy.BaseShareEasyDemo;
import com.flowingcode.vaadin.addons.shareeasy.DropdownShareEasy;
import com.flowingcode.vaadin.addons.shareeasy.FixedShareEasy;
import com.flowingcode.vaadin.addons.shareeasy.HoverShareEasy;
import com.flowingcode.vaadin.addons.shareeasy.NormalShareEasy;
import com.flowingcode.vaadin.addons.shareeasy.ShareEasyDemoView;
import com.flowingcode.vaadin.addons.shareeasy.TextShareEasy;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@DemoSource
@PageTitle(value="Default Values Demo")
@Route(value="share-easy/default-values", layout=ShareEasyDemoView.class)
public class DefaultValuesDemo
extends BaseShareEasyDemo {
    public DefaultValuesDemo() {
        Button showBtn = new Button("Show");
        this.addClassName("share-easy-fixed");
        HorizontalLayout btnsLayout = new HorizontalLayout();
        showBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_LARGE});
        showBtn.setDisableOnClick(true);
        Button hideBtn = new Button("Hide");
        hideBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_LARGE});
        hideBtn.setDisableOnClick(true);
        hideBtn.setEnabled(false);
        btnsLayout.add(new Component[]{showBtn, hideBtn});
        Div example1 = this.createContainerDivWithInfo("Fixed Mode", (Component)btnsLayout, "Fixed Mode: Share Easy menu is attached to the document's body and displays as a vertical menu. By default is added at top left position.");
        SourceCodeViewer.highlightOnHover((Component)example1, (String)"example1");
        this.add(new Component[]{example1});
        this.addSeparator();
        showBtn.addClickListener((ComponentEventListener & Serializable)e -> {
            FixedShareEasy.create().forComponent((Component)this);
            hideBtn.setEnabled(true);
        });
        hideBtn.addClickListener((ComponentEventListener & Serializable)e -> {
            this.removeExistingFixedMenus();
            showBtn.setEnabled(true);
        });
        Div normalDiv = new Div();
        NormalShareEasy.create().forComponent((Component)normalDiv);
        Div example2 = this.createContainerDiv("Normal Mode", (Component)normalDiv);
        SourceCodeViewer.highlightOnHover((Component)example2, (String)"example2");
        this.add(new Component[]{example2});
        this.addSeparator();
        Button dropdownButton = new Button("Share this");
        dropdownButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        DropdownShareEasy.create().forComponent((Component)dropdownButton);
        Div example3 = this.createContainerDivWithInfo("Dropdown Mode", (Component)dropdownButton, "Dropdown Mode: Share Easy menu will appear on hover. As default it will be shown as a column dropdown.");
        SourceCodeViewer.highlightOnHover((Component)example3, (String)"example3");
        this.add(new Component[]{example3});
        this.addSeparator();
        Paragraph paragraph = new Paragraph("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        TextShareEasy.create().forComponent((Component)paragraph);
        Div example4 = this.createContainerDivWithInfo("Text Mode", (Component)paragraph, "Text Mode: Select some text and Share Easy menu will popup to share the selected text.");
        SourceCodeViewer.highlightOnHover((Component)example4, (String)"example4");
        this.add(new Component[]{example4});
        this.addSeparator();
        Button hoverButton = new Button((Component)new Icon(VaadinIcon.CONNECT));
        hoverButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        HoverShareEasy.create().forComponent((Component)hoverButton);
        Div example5 = this.createContainerDivWithInfo("Hover Mode", (Component)hoverButton, "Hover Mode: Share Easy menu will appear on hover and will be displayed as an horizontal/row menu only.");
        SourceCodeViewer.highlightOnHover((Component)example5, (String)"example5");
        this.add(new Component[]{example5});
    }
}

