/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import java.io.Serializable;

public class BaseShareEasyDemo
extends Div {
    public BaseShareEasyDemo() {
        this.setClassName("share-easy-main");
    }

    protected Div createContainerDiv(String title, Component component) {
        Div containerDiv = this.createContainerDiv();
        containerDiv.add(new Component[]{new Span(new Component[]{new Text(title)}), component});
        return containerDiv;
    }

    protected Div createContainerDivWithInfo(String title, Component component, String info) {
        Div containerDiv = this.createContainerDiv();
        Button infoButton = new Button((Component)new Icon(VaadinIcon.INFO_CIRCLE_O));
        infoButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON, ButtonVariant.LUMO_TERTIARY_INLINE});
        infoButton.setTooltipText(info);
        Tooltip tooltip = infoButton.getTooltip().withManual(true);
        infoButton.addClickListener((ComponentEventListener & Serializable)event -> tooltip.setOpened(!tooltip.isOpened()));
        Span titleSpan = new Span(new Component[]{new Text(title), infoButton});
        containerDiv.add(new Component[]{titleSpan, component});
        return containerDiv;
    }

    private Div createContainerDiv() {
        Div containerDiv = new Div();
        containerDiv.setClassName("share-easy-container");
        return containerDiv;
    }

    protected void addSeparator() {
        Element hr = ElementFactory.createHr();
        this.getElement().appendChild(new Element[]{hr});
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.removeExistingFixedMenus();
    }

    protected void removeExistingFixedMenus() {
        this.getElement().executeJs("let fixedSharees = document.getElementsByClassName('sharee__fixed'); while(fixedSharees.length > 0) { fixedSharees[0].remove();}", new Serializable[0]);
    }
}

