/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy.util;

import com.flowingcode.vaadin.addons.shareeasy.ShareEasyDriver;
import com.flowingcode.vaadin.addons.shareeasy.enums.Driver;
import com.flowingcode.vaadin.addons.shareeasy.enums.Locale;
import com.flowingcode.vaadin.addons.shareeasy.util.LanguageKeys;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Options {
    private String shareText;
    private String shareLink;
    private boolean ripple = true;
    private String showTransitionDuration = "200ms";
    private String locale = Locale.ENGLISH.getName();
    private LanguageKeys languageKeys;
    private ShareEasyDriver[] drivers = Driver.values();

    public String getShareText() {
        return this.shareText;
    }

    public void setShareText(String shareText) {
        this.shareText = shareText;
    }

    public String getShareLink() {
        return this.shareLink;
    }

    public void setShareLink(String shareLink) {
        this.shareLink = shareLink;
    }

    public boolean isRipple() {
        return this.ripple;
    }

    public void setRipple(boolean ripple) {
        this.ripple = ripple;
    }

    public String getShowTransitionDuration() {
        return this.showTransitionDuration;
    }

    public void setShowTransitionDuration(String showTransitionDuration) {
        this.showTransitionDuration = showTransitionDuration;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public LanguageKeys getLanguageKeys() {
        return this.languageKeys;
    }

    public void setLanguageKeys(LanguageKeys languageKeys) {
        this.languageKeys = languageKeys;
    }

    public ShareEasyDriver[] getDrivers() {
        return this.drivers;
    }

    public void setDrivers(ShareEasyDriver[] drivers) {
        this.drivers = drivers;
    }

    public JsonObject getJsonObject() {
        JsonObject js = Json.createObject();
        Optional.ofNullable(this.shareText).ifPresent(value -> js.put("shareText", value));
        Optional.ofNullable(this.shareLink).ifPresent(value -> js.put("shareLink", value));
        js.put("ripple", this.ripple);
        js.put("showTransitionDuration", this.showTransitionDuration);
        js.put("lang", this.locale);
        if (this.languageKeys != null && StringUtils.isNotBlank((CharSequence)this.locale)) {
            JsonObject langs = Json.createObject();
            langs.put(this.locale, (JsonValue)this.languageKeys.getJsonObject());
            js.put("langs", (JsonValue)langs);
        }
        JsonArray jsonDriversArray = Json.createArray();
        for (int i = 0; i < this.drivers.length; ++i) {
            jsonDriversArray.set(i, this.drivers[i].getName());
        }
        js.put("drivers", (JsonValue)jsonDriversArray);
        return js;
    }
}

