/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy.util;

import com.flowingcode.vaadin.addons.shareeasy.enums.Driver;
import com.flowingcode.vaadin.addons.shareeasy.enums.Locale;
import com.flowingcode.vaadin.addons.shareeasy.util.LanguageKeys;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Options {
    public String shareText;
    public String shareLink;
    public boolean ripple = true;
    public String showTransitionDuration = "200ms";
    public String locale = Locale.ENGLISH.getName();
    public LanguageKeys languageKeys;
    public Driver[] drivers = Driver.values();

    public JsonObject getJsonObject() {
        JsonObject js = Json.createObject();
        Optional.ofNullable(this.shareText).ifPresent(value -> js.put("shareText", value));
        Optional.ofNullable(this.shareLink).ifPresent(value -> js.put("shareLink", value));
        js.put("ripple", this.ripple);
        js.put("showTransitionDuration", this.showTransitionDuration);
        js.put("lang", this.locale);
        if (this.languageKeys != null && StringUtils.isNotBlank((CharSequence)this.locale)) {
            JsonObject langs = Json.createObject();
            langs.put(this.locale, (JsonValue)this.languageKeys.getJsonObject());
            js.put("langs", (JsonValue)langs);
        }
        JsonArray jsonDriversArray = Json.createArray();
        for (int i = 0; i < this.drivers.length; ++i) {
            jsonDriversArray.set(i, this.drivers[i].getName());
        }
        js.put("drivers", (JsonValue)jsonDriversArray);
        return js;
    }
}

