/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy;

import com.flowingcode.vaadin.addons.shareeasy.BaseShareEasy;
import com.flowingcode.vaadin.addons.shareeasy.enums.Driver;
import com.flowingcode.vaadin.addons.shareeasy.enums.Mode;
import com.flowingcode.vaadin.addons.shareeasy.enums.Position;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.stream.Stream;

public class FixedShareEasy
extends BaseShareEasy<FixedShareEasy> {
    public Position position = Position.TOP_LEFT;
    public boolean noTitle = false;

    public static FixedShareEasy create() {
        Driver[] fixedDrivers = (Driver[])Stream.of(Driver.values()).filter(d -> Driver.COPY != d).toArray(Driver[]::new);
        return (FixedShareEasy)new FixedShareEasy().withDrivers(fixedDrivers);
    }

    public FixedShareEasy withPosition(Position position) {
        this.position = position;
        return this;
    }

    public FixedShareEasy withNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
        return this;
    }

    @Override
    protected JsonObject getJsonObjectOptions() {
        JsonObject js = super.getJsonObjectOptions();
        js.put("mode", Mode.FIXED.getName());
        JsonObject modeOptions = Json.createObject();
        modeOptions.put("position", this.position.getName());
        modeOptions.put("noTitle", this.noTitle);
        js.put("modeOptions", (JsonValue)modeOptions);
        return js;
    }
}

