/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.shareeasy;

import com.flowingcode.vaadin.addons.shareeasy.enums.Driver;
import com.flowingcode.vaadin.addons.shareeasy.enums.Locale;
import com.flowingcode.vaadin.addons.shareeasy.util.CustomDriverOptions;
import com.flowingcode.vaadin.addons.shareeasy.util.LanguageKeys;
import com.flowingcode.vaadin.addons.shareeasy.util.Options;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@NpmPackage(value="sharee", version="1.1.13")
@JsModule(value="./src/fc-sharee-connector.js")
@CssImport(value="./styles/fc-share-easy/style.css")
class BaseShareEasy<T extends BaseShareEasy<T>> {
    private Component component;
    private Options options = new Options();
    Map<String, CustomDriverOptions> customDrivers = new HashMap<String, CustomDriverOptions>();

    BaseShareEasy() {
    }

    public T withShareLink(String shareLink) {
        this.options.shareLink = shareLink;
        return (T)this;
    }

    public T withShareText(String shareText) {
        this.options.shareText = shareText;
        return (T)this;
    }

    public T withRipple(boolean ripple) {
        this.options.ripple = ripple;
        return (T)this;
    }

    public T withShowTransitionDuration(String showTransitionDuration) {
        this.options.showTransitionDuration = showTransitionDuration;
        return (T)this;
    }

    public T withLocale(Locale locale) {
        this.options.locale = locale.getName();
        return (T)this;
    }

    T withDrivers(Driver[] drivers) {
        this.options.drivers = drivers;
        return (T)this;
    }

    public void forComponent(Component component) {
        this.component = component;
        this.createSharee();
    }

    protected JsonObject getJsonObjectOptions() {
        return this.options.getJsonObject();
    }

    private void createSharee() {
        String shareeOptions = this.getJsonObjectOptions().toJson();
        if (!this.customDrivers.isEmpty()) {
            for (CustomDriverOptions options : this.customDrivers.values()) {
                this.component.getElement().executeJs("fcShareeConnector.addCustomDriver(this, $0)", new Serializable[]{options.getJsonObject().toJson()});
            }
            this.component.getElement().executeJs("fcShareeConnector.createWithCustomDrivers(this, $0)", new Serializable[]{shareeOptions});
        } else {
            this.component.getElement().executeJs("fcShareeConnector.create(this, $0)", new Serializable[]{shareeOptions});
        }
    }

    public T withCustomLanguageKeys(LanguageKeys languageKeys) {
        this.options.languageKeys = languageKeys;
        return (T)this;
    }

    public T withCustomLanguageKeys(String locale, LanguageKeys languageKeys) {
        this.options.locale = locale;
        this.options.languageKeys = languageKeys;
        return (T)this;
    }

    public T withCustomDrivers(Map<String, CustomDriverOptions> customDrivers) {
        this.customDrivers = new HashMap<String, CustomDriverOptions>(customDrivers);
        return (T)this;
    }
}

