/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.ics;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;

@NpmPackage(value="img-comparison-slider", version="7.3.2")
@JsModule(value="img-comparison-slider/dist/index.js")
@CssImport(value="img-comparison-slider/dist/styles.css")
@Tag(value="img-comparison-slider")
public class ImageComparisonSlider
extends Div {
    public ImageComparisonSlider(String srcFirst, String altFirst, String srcSecond, String altSecond) {
        Image img1 = new Image(srcFirst, altFirst);
        Image img2 = new Image(srcSecond, altSecond);
        img1.getElement().setAttribute("slot", "first");
        img2.getElement().setAttribute("slot", "second");
        this.add(new Component[]{img1});
        this.add(new Component[]{img2});
    }

    public ImageComparisonSlider(Image first, Image second) {
        first.getElement().setAttribute("slot", "first");
        second.getElement().setAttribute("slot", "second");
        this.add(new Component[]{first});
        this.add(new Component[]{second});
    }

    public void setValue(Integer value) {
        this.getElement().setProperty("value", (double)value.intValue());
    }

    public Integer getValue() {
        return this.getElement().getProperty("value", 50);
    }

    public void setSlideOnHover(boolean value) {
        this.getElement().setAttribute("hover", value);
    }

    public boolean isSlideOnHover() {
        return "true".equals(this.getElement().getAttribute("hover"));
    }
}

