/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.StringUtils;
import com.vaadin.flow.function.SerializableFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

final class GridHelperClassNameGenerator<T>
implements SerializableFunction<T, String> {
    private Map<Class<?>, SerializableFunction<T, String>> helperClassNameGenerators = new HashMap();
    private SerializableFunction<T, String> gridClassNameGenerator;
    private transient boolean invoked;

    GridHelperClassNameGenerator() {
    }

    void setHelperClassNameGenerator(Class<?> clazz, SerializableFunction<T, String> generator) {
        if (generator != null) {
            this.helperClassNameGenerators.put(clazz, generator);
        } else {
            this.helperClassNameGenerators.remove(clazz);
        }
    }

    private Stream<SerializableFunction<T, String>> generators() {
        return Stream.concat(Optional.ofNullable(this.gridClassNameGenerator).map(Stream::of).orElseGet(Stream::empty), this.helperClassNameGenerators.values().stream());
    }

    public String apply(T t) {
        if (this.invoked) {
            return null;
        }
        this.invoked = true;
        try {
            String string = StringUtils.trimToNull(this.generators().map(generator -> (String)generator.apply(t)).map(StringUtils::trimToNull).filter(Objects::nonNull).flatMap(s -> Stream.of(s.trim().split("\\s+"))).distinct().collect(Collectors.joining(" ")));
            return string;
        }
        finally {
            this.invoked = false;
        }
    }

    @Generated
    public SerializableFunction<T, String> getGridClassNameGenerator() {
        return this.gridClassNameGenerator;
    }

    @Generated
    public void setGridClassNameGenerator(SerializableFunction<T, String> gridClassNameGenerator) {
        this.gridClassNameGenerator = gridClassNameGenerator;
    }
}

