/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridResponsiveStep;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;

class ResponsiveGridHelper<T>
implements Serializable {
    private final GridHelper<T> helper;
    private boolean initialized;
    private NavigableMap<Integer, GridResponsiveStep<T>> steps = new TreeMap<Integer, GridResponsiveStep<T>>();
    private int currentMinWidth = -1;
    private Registration refreshRegistration;

    Grid<T> getGrid() {
        return this.helper.getGrid();
    }

    GridResponsiveStep<T> getOrCreate(int minWidth) {
        Grid<T> grid = this.helper.getGrid();
        if (minWidth < 0) {
            throw new IllegalArgumentException();
        }
        this.steps.computeIfAbsent(minWidth, w -> new GridResponsiveStep((int)w, this));
        if (this.initialized) {
            this.sendSteps();
        } else {
            this.initialized = true;
            grid.addAttachListener((ComponentEventListener & Serializable)ev -> this.initialize());
            if (grid.isAttached()) {
                this.initialize();
            }
        }
        return (GridResponsiveStep)this.steps.get(minWidth);
    }

    private void initialize() {
        Grid<T> grid = this.helper.getGrid();
        grid.getElement().addEventListener("fcgh-responsive-step", (DomEventListener & Serializable)ev -> this.apply((int)JsonMigration.getEventData((DomEvent)ev).getNumber("event.detail.step"), false)).addEventData("event.detail.step").debounce(200, DebouncePhase.TRAILING, new DebouncePhase[0]);
        this.sendSteps();
    }

    private void sendSteps() {
        JsonArray widths = Json.createArray();
        this.steps.keySet().forEach(w -> widths.set(widths.length(), (double)w.intValue()));
        this.helper.getGrid().getElement().executeJs("this.fcGridHelper._setResponsiveSteps($0)", new Serializable[]{widths});
    }

    private void refresh() {
        this.apply(this.currentMinWidth, true);
    }

    void requireRefresh(GridResponsiveStep<T> step) {
        if (step.getMinWidth() <= this.currentMinWidth) {
            Grid<T> grid = this.helper.getGrid();
            grid.getUI().ifPresent(ui -> {
                if (this.refreshRegistration != null) {
                    this.refreshRegistration.remove();
                }
                this.refreshRegistration = ui.beforeClientResponse((Component)grid, (SerializableConsumer & Serializable)context -> this.refresh());
            });
        }
    }

    private void apply(int width, boolean force) {
        if (this.steps.floorKey(width) != null) {
            Grid<T> grid = this.helper.getGrid();
            GridResponsiveStep<T> step = new GridResponsiveStep().show(grid.getColumns());
            this.steps.subMap(0, true, width, true).values().forEach(step::accumulate);
            if (step.getMinWidth() >= 0 && (force || this.currentMinWidth != step.getMinWidth())) {
                this.currentMinWidth = step.getMinWidth();
                step.apply(this.helper.getGrid());
            }
        } else {
            this.currentMinWidth = -1;
        }
    }

    void remove(GridResponsiveStep<?> step) {
        if (!this.steps.remove(step.getMinWidth(), step)) {
            throw new IllegalArgumentException("The responsive step is not connected to this grid");
        }
        this.sendSteps();
    }

    Collection<GridResponsiveStep<T>> getAll() {
        return Collections.unmodifiableCollection(this.steps.values());
    }

    @Generated
    public ResponsiveGridHelper(GridHelper<T> helper) {
        this.helper = helper;
    }

    @Generated
    public int getCurrentMinWidth() {
        return this.currentMinWidth;
    }
}

