/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.ColumnToggleEvent;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

class ColumnToggleHelper<T>
implements Serializable {
    private static final String GRID_HELPER_TOGGLE_THEME = "gridHelperToggle";
    private static final String TOGGLE_CAPTION_DATA = GridHelper.class.getName() + "#TOGGLE_CAPTION";
    private static final String HIDABLE_DATA = GridHelper.class.getName() + "#HIDABLE";
    private final GridHelper<T> helper;
    private Grid.Column<?> menuToggleColumn;

    public void setColumnToggleVisible(boolean visible) {
        if (visible) {
            this.showColumnToggle();
        } else {
            this.hideColumnToggle();
        }
    }

    public boolean isColumnToggleVisible() {
        return this.menuToggleColumn != null && this.menuToggleColumn.isVisible();
    }

    private void showColumnToggle() {
        this.createMenuToggle().ifPresent(toggle -> {
            Grid<T> grid = this.helper.getGrid();
            if (this.menuToggleColumn == null) {
                this.menuToggleColumn = grid.addColumn((ValueProvider & Serializable)t -> "").setWidth("auto").setFlexGrow(0);
            } else {
                this.menuToggleColumn.setVisible(true);
            }
            ((HeaderRow.HeaderCell)((HeaderRow)grid.getHeaderRows().get(0)).getCell(this.menuToggleColumn)).setComponent((Component)toggle);
        });
    }

    private void hideColumnToggle() {
        if (this.menuToggleColumn != null) {
            this.menuToggleColumn.setVisible(false);
        }
    }

    private Optional<MenuBar> createMenuToggle() {
        Grid<T> grid = this.helper.getGrid();
        MenuBar menuBar = new MenuBar();
        menuBar.getThemeNames().add((Object)MenuBarVariant.LUMO_TERTIARY_INLINE.getVariantName());
        MenuItem menuItem = menuBar.addItem((Component)VaadinIcon.ELLIPSIS_DOTS_V.create());
        SubMenu subMenu = (SubMenu)menuItem.getSubMenu();
        for (Grid.Column column : grid.getColumns()) {
            if (!this.isHidable(column)) continue;
            String label = this.getHidingToggleCaption(column);
            Checkbox checkbox = new Checkbox(label);
            checkbox.setValue((Object)column.isVisible());
            checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.setColumnVisible(column, (Boolean)e.getValue()));
            MenuItem submenuItem = (MenuItem)subMenu.addItem((Component)checkbox);
            submenuItem.addAttachListener((ComponentEventListener & Serializable)ev -> ColumnToggleHelper.stopClickPropagation(submenuItem));
            ColumnToggleHelper.stopClickPropagation(submenuItem);
        }
        menuBar.getThemeNames().add((Object)GRID_HELPER_TOGGLE_THEME);
        return Optional.of(menuBar).filter(_menuBar -> !_menuBar.getItems().isEmpty());
    }

    private static void stopClickPropagation(MenuItem menuItem) {
        menuItem.getElement().executeJs("this.addEventListener('click',ev=>ev.stopPropagation())", new Serializable[0]);
    }

    private void setColumnVisible(Grid.Column<T> column, boolean visible) {
        Grid<T> grid = this.helper.getGrid();
        column.setVisible(visible);
        ComponentUtil.fireEvent(this.helper.getGrid(), new ColumnToggleEvent<T>(grid, column, true));
    }

    public Registration addColumnToggleListener(@NonNull ComponentEventListener<ColumnToggleEvent<T>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Class<ColumnToggleEvent> eventType = ColumnToggleEvent.class;
        return ComponentUtil.addListener(this.helper.getGrid(), eventType, listener);
    }

    public String getHidingToggleCaption(@NonNull Grid.Column<?> column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        Grid grid = this.helper.getGrid();
        return Optional.ofNullable((String)ComponentUtil.getData(column, (String)TOGGLE_CAPTION_DATA)).orElseGet(() -> GridHelper.getHeader(grid, column));
    }

    public boolean isHidable(Grid.Column<?> column) {
        return column != null && Boolean.TRUE.equals(ComponentUtil.getData(column, (String)HIDABLE_DATA));
    }

    public void setHidable(Grid.Column<?> column, boolean hidable) {
        if (column != null) {
            Grid<T> grid = this.helper.getGrid();
            if (!grid.getColumns().contains(column)) {
                throw new IllegalArgumentException();
            }
            ComponentUtil.setData(column, (String)HIDABLE_DATA, (Object)hidable);
            if (this.isColumnToggleVisible()) {
                this.showColumnToggle();
            }
        }
    }

    public void setHidingToggleCaption(Grid.Column<?> column, String caption) {
        if (column != null) {
            Grid<T> grid = this.helper.getGrid();
            if (!grid.getColumns().contains(column)) {
                throw new IllegalArgumentException();
            }
            ComponentUtil.setData(column, (String)TOGGLE_CAPTION_DATA, (Object)caption);
            if (caption != null && ComponentUtil.getData(column, (String)HIDABLE_DATA) == null) {
                ComponentUtil.setData(column, (String)HIDABLE_DATA, (Object)Boolean.TRUE);
            }
            if (this.isColumnToggleVisible()) {
                this.showColumnToggle();
            }
        }
    }

    Grid.Column<?> getMenuToggleColumn() {
        return this.menuToggleColumn;
    }

    @Generated
    public ColumnToggleHelper(GridHelper<T> helper) {
        this.helper = helper;
    }
}

