/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class CheckboxColumn<T>
implements Serializable {
    private final Grid<T> grid;
    private final Grid.Column<T> column;
    private final Map<T, Boolean> itemsState = new HashMap<T, Boolean>();
    private final transient IntSupplier totalItemsCount;
    private final transient IntSupplier selectedItemsCount;
    private final Checkbox selectAllCheckbox;
    private final CheckboxColumnConfiguration<T> config;
    private SerializableBiConsumer<T, Boolean> checkboxClickListener;
    private SerializableConsumer<Integer> checkedCountListener;

    CheckboxColumn(Grid<T> grid, CheckboxColumnConfiguration<T> config) {
        this.grid = grid;
        this.config = config;
        if (config.selectAllCheckboxVisible == null) {
            config.selectAllCheckboxVisible = grid.getDataProvider().isInMemory();
        }
        if (!config.readOnly && Boolean.TRUE.equals(config.selectAllCheckboxVisible)) {
            this.totalItemsCount = () -> this.getItemsCount(grid);
            this.selectedItemsCount = () -> (int)this.itemsState.values().stream().filter(Boolean.TRUE::equals).count();
        } else {
            this.totalItemsCount = () -> 0;
            this.selectedItemsCount = () -> 0;
        }
        this.selectAllCheckbox = this.buildSelectAllCheckbox(config, grid).orElse(null);
        this.column = (Grid.Column)grid.addComponentColumn((ValueProvider & Serializable)item -> this.buildCheckbox(config, item)).setTextAlign(ColumnTextAlign.CENTER);
        if (config.readOnly) {
            this.column.setHeader(config.header);
        } else {
            this.initializeNotReadOnly(grid, config);
        }
    }

    private void initializeNotReadOnly(Grid<T> grid, CheckboxColumnConfiguration<T> config) {
        if (this.selectAllCheckbox != null) {
            this.column.setHeader((Component)this.selectAllCheckbox);
        } else {
            this.column.setHeader(config.header);
        }
        this.column.addAttachListener((ComponentEventListener & Serializable)e -> {
            if (e.isInitialAttach()) {
                this.initItemsState(grid, config.getter);
                this.initializeSelectAllCheckbox(grid, this.selectAllCheckbox, config.getter);
            }
        });
    }

    public void refresh() {
        this.initItemsState(this.grid, this.config.getter);
        this.initializeSelectAllCheckbox(this.grid, this.selectAllCheckbox, this.config.getter);
    }

    private void initializeSelectAllCheckbox(Grid<T> grid, Checkbox selectAllCheckbox, ValueProvider<T, Boolean> getter) {
        if (selectAllCheckbox != null) {
            int initialSelectedItemsCountValue = this.getInitialSelectItemsCount(grid, getter);
            int totalItemsCountValue = this.totalItemsCount.getAsInt();
            selectAllCheckbox.setValue((Object)(initialSelectedItemsCountValue > 0 ? 1 : 0));
            selectAllCheckbox.setIndeterminate(initialSelectedItemsCountValue < totalItemsCountValue);
        }
    }

    public Set<T> getSelectedItems() {
        return this.itemsState.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private int getItemsCount(Grid<T> grid) {
        return grid.getDataProvider().isInMemory() ? grid.getListDataView().getItemCount() : (int)grid.getLazyDataView().getItems().count();
    }

    private int getInitialSelectItemsCount(Grid<T> grid, ValueProvider<T, Boolean> filter) {
        return grid.getDataProvider().isInMemory() ? (int)grid.getListDataView().getItems().filter(arg_0 -> filter.apply(arg_0)).count() : (int)grid.getLazyDataView().getItems().filter(arg_0 -> filter.apply(arg_0)).count();
    }

    private void initItemsState(Grid<T> grid, ValueProvider<T, Boolean> getter) {
        this.itemsState.clear();
        if (grid.getDataProvider().isInMemory()) {
            grid.getListDataView().getItems().forEach(item -> this.itemsState.computeIfAbsent((T)item, (Function<T, Boolean>)getter));
        } else {
            grid.getLazyDataView().getItems().forEach(item -> this.itemsState.computeIfAbsent((T)item, (Function<T, Boolean>)getter));
        }
    }

    private Optional<Checkbox> buildSelectAllCheckbox(CheckboxColumnConfiguration<T> config, Grid<T> grid) {
        if (config.readOnly || Boolean.TRUE.equals(config.selectAllCheckboxVisible == false)) {
            return Optional.empty();
        }
        Checkbox checkbox = new Checkbox(config.header);
        checkbox.setIndeterminate(this.someItemsSelected());
        checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!e.isFromClient()) {
                return;
            }
            if (this.someItemsSelected() && Boolean.TRUE.equals((Boolean)e.getValue() == false)) {
                checkbox.setValue((Object)true);
            }
            Stream items = grid.getDataProvider().isInMemory() ? grid.getListDataView().getItems() : grid.getLazyDataView().getItems();
            this.itemsState.clear();
            items.forEach(item -> this.itemsState.put(item, (Boolean)checkbox.getValue()));
            grid.getDataProvider().refreshAll();
            checkbox.setIndeterminate(this.someItemsSelected());
            this.notifyCheckedCountChanged(this.checkedCountListener);
        });
        checkbox.getElement().getThemeList().add((Object)"fcgh-small");
        if (config.header != null && config.checkboxPosition.theme != null) {
            checkbox.getElement().getThemeList().add((Object)config.checkboxPosition.theme);
        }
        return Optional.of(checkbox);
    }

    private void notifyCheckboxClicked(SerializableBiConsumer<T, Boolean> listener, T item, boolean value) {
        Optional.ofNullable(listener).ifPresent(l -> l.accept(item, (Object)value));
    }

    private void notifyCheckedCountChanged(SerializableConsumer<Integer> listener) {
        Optional.ofNullable(listener).ifPresent(l -> l.accept((Object)this.getSelectedItems().size()));
    }

    private boolean someItemsSelected() {
        return this.selectedItemsCount.getAsInt() > 0 && this.selectedItemsCount.getAsInt() < this.totalItemsCount.getAsInt();
    }

    private boolean allItemsSelected() {
        return this.totalItemsCount.getAsInt() == this.selectedItemsCount.getAsInt();
    }

    private Checkbox buildCheckbox(CheckboxColumnConfiguration<T> config, T item) {
        Checkbox checkbox = new Checkbox(this.itemsState.computeIfAbsent(item, arg_0 -> config.getter.apply(arg_0)).booleanValue());
        checkbox.setReadOnly(config.readOnly);
        if (!config.readOnly) {
            checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                this.itemsState.put(item, (Boolean)e.getValue());
                if (this.selectAllCheckbox != null) {
                    if (this.allItemsSelected()) {
                        this.selectAllCheckbox.setValue((Object)true);
                        this.selectAllCheckbox.setIndeterminate(false);
                    } else if (this.someItemsSelected()) {
                        this.selectAllCheckbox.setValue((Object)true);
                        this.selectAllCheckbox.setIndeterminate(true);
                    } else {
                        this.selectAllCheckbox.setValue((Object)false);
                        this.selectAllCheckbox.setIndeterminate(false);
                    }
                }
                this.notifyCheckboxClicked(this.checkboxClickListener, item, (Boolean)e.getValue());
                this.notifyCheckedCountChanged(this.checkedCountListener);
            });
        }
        return checkbox;
    }

    @Generated
    public CheckboxColumn(Grid<T> grid, Grid.Column<T> column, IntSupplier totalItemsCount, IntSupplier selectedItemsCount, Checkbox selectAllCheckbox, CheckboxColumnConfiguration<T> config) {
        this.grid = grid;
        this.column = column;
        this.totalItemsCount = totalItemsCount;
        this.selectedItemsCount = selectedItemsCount;
        this.selectAllCheckbox = selectAllCheckbox;
        this.config = config;
    }

    @Generated
    public Grid.Column<T> column() {
        return this.column;
    }

    @Generated
    public CheckboxColumn<T> checkboxClickListener(SerializableBiConsumer<T, Boolean> checkboxClickListener) {
        this.checkboxClickListener = checkboxClickListener;
        return this;
    }

    @Generated
    public CheckboxColumn<T> checkedCountListener(SerializableConsumer<Integer> checkedCountListener) {
        this.checkedCountListener = checkedCountListener;
        return this;
    }

    public static class CheckboxColumnConfiguration<T>
    implements Serializable {
        private final ValueProvider<T, Boolean> getter;
        private String header;
        private boolean readOnly = false;
        private Boolean selectAllCheckboxVisible;
        private CheckboxPosition checkboxPosition = CheckboxPosition.TOP;

        @Generated
        public CheckboxColumnConfiguration(ValueProvider<T, Boolean> getter) {
            this.getter = getter;
        }

        @Generated
        public CheckboxColumnConfiguration<T> header(String header) {
            this.header = header;
            return this;
        }

        @Generated
        public CheckboxColumnConfiguration<T> readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Generated
        public CheckboxColumnConfiguration<T> selectAllCheckboxVisible(Boolean selectAllCheckboxVisible) {
            this.selectAllCheckboxVisible = selectAllCheckboxVisible;
            return this;
        }

        @Generated
        public CheckboxColumnConfiguration<T> checkboxPosition(CheckboxPosition checkboxPosition) {
            this.checkboxPosition = checkboxPosition;
            return this;
        }
    }

    public static enum CheckboxPosition {
        TOP("fcgh-checkbox-top"),
        RIGHT("fcgh-checkbox-right"),
        BOTTOM("fcgh-checkbox-bottom"),
        LEFT("fcgh-checkbox-left");

        private String theme;

        @Generated
        private CheckboxPosition(String theme) {
            this.theme = theme;
        }
    }
}

