/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.github.javafaker.Faker;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

class LazyTestData
implements Serializable {
    private static final Faker faker = new Faker();
    private final List<Person> data = Stream.generate(LazyTestData::newPerson).limit(400L).collect(Collectors.toList());

    private static synchronized Person newPerson() {
        return Person.builder().active(faker.random().nextBoolean()).vip(faker.random().nextBoolean()).hidden(faker.random().nextBoolean()).firstName(faker.name().firstName()).lastName(faker.name().lastName()).country(LazyTestData.generateCountry()).city(faker.address().city()).streetAddress(faker.address().streetAddress()).phoneNumber(faker.phoneNumber().cellPhone()).emailAddress(faker.internet().emailAddress()).title(faker.name().title()).build();
    }

    public Stream<Person> filter(int offset, int pageSize) {
        return this.filter(offset, pageSize, null);
    }

    public Stream<Person> filter(int offset, int pageSize, PersonFilter filter) {
        int from = Math.max(0, offset);
        if (filter != null) {
            return this.data.stream().filter(item -> StringUtils.containsIgnoreCase((CharSequence)item.getFirstName(), (CharSequence)filter.getFirstName())).filter(item -> StringUtils.containsIgnoreCase((CharSequence)item.getLastName(), (CharSequence)filter.getLastName())).skip(from).limit(pageSize);
        }
        return this.data.stream().skip(from).limit(pageSize);
    }

    public int count() {
        return this.data.size();
    }

    public int count(PersonFilter filter) {
        return (int)this.data.stream().filter(item -> StringUtils.containsIgnoreCase((CharSequence)item.getFirstName(), (CharSequence)filter.getFirstName())).filter(item -> StringUtils.containsIgnoreCase((CharSequence)item.getLastName(), (CharSequence)filter.getLastName())).count();
    }

    private static String generateCountry() {
        String country = faker.address().country();
        if (country.contains("South Georgia") || country.contains("Falkland")) {
            return "Argentina";
        }
        return country;
    }

    public static class PersonFilter {
        private String firstName;
        private String lastName;

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

