/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelpersDemoView;
import com.flowingcode.vaadin.addons.gridhelpers.LazyTestData;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.function.Function;

@PageTitle(value="Empty Grid Label")
@DemoSource
@Route(value="grid-helpers/empty-grid-label", layout=GridHelpersDemoView.class)
public class EmptyGridLabelDemo
extends VerticalLayout {
    public EmptyGridLabelDemo() {
        LazyTestData data = new LazyTestData();
        this.setSpacing(false);
        this.setPadding(false);
        this.setSizeFull();
        TextField firstName = new TextField("Firstname");
        TextField lastName = new TextField("Lastname");
        Function<Query, LazyTestData.PersonFilter> filterBuilder = query -> {
            LazyTestData.PersonFilter filter = query.getFilter().orElse(new LazyTestData.PersonFilter());
            filter.setFirstName(firstName.getValue());
            filter.setLastName(lastName.getValue());
            return filter;
        };
        CallbackDataProvider dataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> data.filter(query.getOffset(), query.getPageSize(), (LazyTestData.PersonFilter)filterBuilder.apply(query)), (CallbackDataProvider.CountCallback & Serializable)query -> data.count((LazyTestData.PersonFilter)filterBuilder.apply(query)));
        Grid grid = new Grid();
        grid.setDataProvider((DataProvider)dataProvider);
        grid.addColumn(Person::getFirstName).setHeader("First name");
        grid.addColumn(Person::getLastName).setHeader("Last name");
        grid.addColumn(Person::getCountry).setHeader("Country");
        grid.setSizeFull();
        Div emptyGridLabel = new Div(new Component[]{new Text("No records found")});
        emptyGridLabel.setSizeFull();
        emptyGridLabel.addClassName("empty-grid-label");
        emptyGridLabel.setVisible(false);
        GridHelper.setEmptyGridLabel((Grid)grid, (Component)emptyGridLabel);
        Button filterButton = new Button("Filter");
        filterButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        filterButton.addClickListener(arg_0 -> EmptyGridLabelDemo.lambda$new$4e42c042$1((DataProvider)dataProvider, arg_0));
        Div gridContainer = new Div(new Component[]{grid, emptyGridLabel});
        gridContainer.getStyle().set("position", "relative");
        gridContainer.setSizeFull();
        FormLayout filtersForm = new FormLayout(new Component[]{firstName, lastName});
        filtersForm.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2)});
        filtersForm.setWidthFull();
        HorizontalLayout filters = new HorizontalLayout(new Component[]{filtersForm, filterButton});
        filters.setAlignItems(FlexComponent.Alignment.END);
        filters.setWidthFull();
        filters.getStyle().set("padding-right", "4px");
        this.add(new Component[]{filters, gridContainer});
    }

    private static /* synthetic */ void lambda$new$4e42c042$1(DataProvider dataProvider, ClickEvent e) {
        dataProvider.refreshAll();
    }
}

