/*-
 * #%L
 * Grid Helpers Add-on
 * %%
 * Copyright (C) 2022 - 2024 Flowing Code
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package com.flowingcode.vaadin.addons.gridhelpers;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;

/**
 * Server side implementation for the flow specific grid radio selection column.
 */
@Tag("grid-flow-radio-selection-column")
@NpmPackage(value = "@vaadin/polymer-legacy-adapter", version = "24.3.2")
@JsModule("@vaadin/polymer-legacy-adapter/style-modules.js")
@JsModule("./fcGridHelper/grid-flow-radio-selection-column.js")
public class GridRadioSelectionColumn extends Component implements HasStyle {

  /**
   * Sets this column's frozen state.
   *
   * @param frozen whether to freeze or unfreeze this column
   */
  public void setFrozen(boolean frozen) {
    getElement().setProperty("frozen", frozen);
  }

  /**
   * Gets the this column's frozen state.
   *
   * @return whether this column is frozen
   */
  @Synchronize("frozen-changed")
  public boolean isFrozen() {
    return getElement().getProperty("frozen", false);
  }

}
