/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelpersDemoView;
import com.flowingcode.vaadin.addons.gridhelpers.LazyTestData;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Radio Selection Column")
@DemoSource
@Route(value="grid-helpers/radio-selection-column", layout=GridHelpersDemoView.class)
public class GridRadioSelectionColumnDemo
extends VerticalLayout {
    Div selection = new Div();

    public GridRadioSelectionColumnDemo() {
        this.setSizeFull();
        Grid grid = new Grid();
        LazyTestData data = new LazyTestData();
        grid.setItems((BackEndDataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> data.filter(query.getOffset(), query.getPageSize()), (CallbackDataProvider.CountCallback & Serializable)query -> data.count()));
        grid.addColumn(Person::getFirstName).setHeader("First name");
        grid.addColumn(Person::getLastName).setHeader("Last name");
        grid.addColumn(Person::getPhoneNumber).setHeader("Phone");
        GridHelper.showRadioSelectionColumn((Grid)grid).setFrozen(true);
        grid.setSizeFull();
        ((GridSingleSelectionModel)grid.getSelectionModel()).setDeselectAllowed(false);
        grid.asSingleSelect().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null) {
                this.selection.setText("Selected row: " + ((Person)e.getValue()).getFirstName() + " " + ((Person)e.getValue()).getLastName());
            }
        });
        this.add(new Component[]{grid, this.selection});
    }
}

