/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridhelpers.CheckboxColumn;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelpersDemoView;
import com.flowingcode.vaadin.addons.gridhelpers.LazyTestData;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Checkbox Column")
@DemoSource
@Route(value="grid-helpers/checkbox-column", layout=GridHelpersDemoView.class)
public class CheckboxColumnDemo
extends VerticalLayout {
    public CheckboxColumnDemo() {
        this.setSizeFull();
        Span activeCount = new Span();
        Span vipCount = new Span();
        Grid grid = new Grid();
        LazyTestData data = new LazyTestData();
        grid.setItems((BackEndDataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> data.filter(query.getOffset(), query.getPageSize()), (CallbackDataProvider.CountCallback & Serializable)query -> data.count()));
        grid.addColumn(Person::getFirstName).setHeader("First name");
        grid.addColumn(Person::getLastName).setHeader("Last name");
        CheckboxColumn activeColumn = GridHelper.addCheckboxColumn((Grid)grid, (CheckboxColumn.CheckboxColumnConfiguration)new CheckboxColumn.CheckboxColumnConfiguration(Person::isActive).header("Active").checkboxPosition(CheckboxColumn.CheckboxPosition.LEFT).selectAllCheckboxVisible(Boolean.valueOf(true))).checkboxClickListener((SerializableBiConsumer & Serializable)(item, checked) -> Notification.show((String)(item.getFirstName() + " " + item.getLastName() + " " + (checked != false ? "checked" : "unchecked")))).checkedCountListener((SerializableConsumer & Serializable)count -> activeCount.setText("Active count: " + count));
        GridHelper.addCheckboxColumn((Grid)grid, (CheckboxColumn.CheckboxColumnConfiguration)new CheckboxColumn.CheckboxColumnConfiguration(Person::isVip).header("VIP")).checkboxClickListener((SerializableBiConsumer & Serializable)(item, checked) -> Notification.show((String)(item.getFirstName() + " " + item.getLastName() + " " + (checked != false ? "checked" : "unchecked")))).checkedCountListener((SerializableConsumer & Serializable)count -> vipCount.setText("VIP count: " + count));
        GridHelper.addCheckboxColumn((Grid)grid, (CheckboxColumn.CheckboxColumnConfiguration)new CheckboxColumn.CheckboxColumnConfiguration(Person::isHidden).header("Hidden").readOnly(true));
        grid.setSizeFull();
        Button toggleVipColumn = new Button("Refresh grid data");
        toggleVipColumn.addClickListener((ComponentEventListener & Serializable)e -> {
            LazyTestData newData = new LazyTestData();
            grid.setItems((BackEndDataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> newData.filter(query.getOffset(), query.getPageSize()), (CallbackDataProvider.CountCallback & Serializable)query -> newData.count()));
            activeColumn.refresh();
        });
        this.add(new Component[]{grid, toggleVipColumn, new HorizontalLayout(new Component[]{activeCount, vipCount})});
    }
}

