/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.gridhelpers.CheckboxColumn;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelpersDemoView;
import com.flowingcode.vaadin.addons.gridhelpers.HeightMode;
import com.flowingcode.vaadin.addons.gridhelpers.LazyTestData;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

@PageTitle(value="All Features")
@Route(value="grid-helpers/all-features", layout=GridHelpersDemoView.class)
@GithubLink(value="https://github.com/FlowingCode/GridHelpers")
@StyleSheet(value="context://gridhelpers/styles.css")
@JavaScript(value="context://gridhelpers/gridhelpers-demo.js")
public class AllFeaturesDemo
extends Div {
    private final CheckboxColumn<Person> activeCheckboxColumn;
    private final Map<Checkbox, List<Grid.SelectionMode>> checkboxes = new HashMap<Checkbox, List<Grid.SelectionMode>>();

    public AllFeaturesDemo() {
        this.setSizeFull();
        this.getElement().getStyle().set("flex-grow", "1");
        Grid grid = new Grid();
        grid.setColumnReorderingAllowed(true);
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getLastName).setHeader("Last name"), (String)"Last name column");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getFirstName).setHeader("First name"), (String)"First name column");
        this.activeCheckboxColumn = GridHelper.addCheckboxColumn((Grid)grid, (CheckboxColumn.CheckboxColumnConfiguration)new CheckboxColumn.CheckboxColumnConfiguration(Person::isActive).header("Active").checkboxPosition(CheckboxColumn.CheckboxPosition.BOTTOM));
        GridHelper.setHidable((Grid.Column)this.activeCheckboxColumn.column(), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getTitle).setHeader("Title"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getCountry).setHeader("Country"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getCity).setHeader("City"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getStreetAddress).setHeader("Street Address"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getPhoneNumber).setHeader("Phone Number"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getEmailAddress).setHeader("Email Address"), (boolean)true);
        grid.getColumns().forEach(c -> c.setAutoWidth(true));
        grid.setItems(TestData.initializeData());
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.getElement().getStyle().set("flex-grow", "1");
        GridHelper.getHeaderStyles((Grid)grid, (HeaderRow.HeaderCell)((HeaderRow.HeaderCell)((HeaderRow)grid.getHeaderRows().get(0)).getCells().get(1))).setClassName("fcGh-demo-custom-header");
        grid.getElement().executeJs("var e = document.createElement('style'); e.innerHTML='.fcGh-demo-custom-header  {background: #888}'; this.shadowRoot.appendChild(e);", new Serializable[0]);
        IntStream.iterate(0, i -> i + 100).skip(1L).limit(20L).forEach(w -> GridHelper.responsiveStep((Grid)grid, (int)w).addListener((SerializableConsumer & Serializable)ev -> Notification.show((String)("Responsive step: " + ev.getMinWidth()))));
        VerticalLayout features = new VerticalLayout();
        features.getStyle().set("margin-left", "4px");
        features.getStyle().set("margin-right", "-4px");
        features.getStyle().set("min-width", "310px");
        features.setPadding(false);
        features.setSpacing(false);
        features.setWidth(null);
        VerticalLayout layout = new VerticalLayout(new Component[]{grid});
        layout.setPadding(false);
        SplitLayout split = new SplitLayout((Component)layout, (Component)features);
        split.setSplitterPosition(100.0);
        split.setHeightFull();
        this.add(new Component[]{split});
        GridHelper.setSelectOnClick((Grid)grid, (boolean)true);
        GridHelper.setColumnToggleVisible((Grid)grid, (boolean)true);
        GridHelper.addColumnToggleListener((Grid)grid, (ComponentEventListener & Serializable)ev -> {
            String caption = GridHelper.getHidingToggleCaption((Grid.Column)ev.getColumn());
            String message = caption + " is now " + (ev.getColumn().isVisible() ? "visible" : "invisible");
            new Notification(message).open();
        });
        Binder binder = new Binder();
        binder.setBean((Object)grid);
        Select select = new Select();
        select.setItems((Object[])Grid.SelectionMode.values());
        select.setLabel("Selection mode");
        binder.forField((HasValue)select).bind(GridHelper::getSelectionMode, this::setSelectionMode);
        Checkbox useLazyData = new Checkbox("Use lazy data provider");
        binder.forField((HasValue)useLazyData).bind(this::isUseLazyData, this::setUseLazyData);
        this.add(new Component[]{useLazyData});
        binder.forField((HasValue)this.newCheckbox("Hide selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnHidden, GridHelper::setSelectionColumnHidden);
        binder.forField((HasValue)this.newCheckbox("Freeze selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnFrozen, GridHelper::setSelectionColumnFrozen);
        binder.forField((HasValue)this.newCheckbox("Arrow selection enabled", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(GridHelper::isArrowSelectionEnabled, GridHelper::setArrowSelectionEnabled);
        binder.forField((HasValue)this.newCheckbox("Enhanced selection enabled", Grid.SelectionMode.MULTI)).bind(GridHelper::isEnhancedSelectionEnabled, GridHelper::setEnhancedSelectionEnabled);
        binder.forField((HasValue)this.newCheckbox("Enable selection by clicking row", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectOnClick, GridHelper::setSelectOnClick);
        binder.forField((HasValue)this.newCheckbox("Disallow selection of 'inactive' records", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(this::hasSelectionFilter, this::setSelectionFilter);
        binder.forField((HasValue)new Checkbox("Dense Theme")).bind(this::hasDenseTheme, this::setDenseTheme);
        binder.forField((HasValue)this.newCheckbox("Hide headers", new Grid.SelectionMode[0])).bind(this::isHeaderHidden, this::setHeaderHidden);
        binder.forField((HasValue)this.newCheckbox("Hide footers", new Grid.SelectionMode[0])).bind(this::isFooterHidden, this::setFooterHidden);
        Checkbox cbHeightByRows = this.newCheckbox("Height by rows enabled", new Grid.SelectionMode[0]);
        binder.forField((HasValue)cbHeightByRows).bind(this::isHeightByRowsEnabled, this::setHeightByRowsEnabled);
        IntegerField heightByRowsField = new IntegerField("Height by rows");
        cbHeightByRows.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> heightByRowsField.setEnabled(((Boolean)ev.getValue()).booleanValue()));
        binder.forField((HasValue)heightByRowsField).bind(this::getHeightByRows, this::setHeightByRows);
        this.updateHeightByRowsField(grid, heightByRowsField);
        heightByRowsField.setStepButtonsVisible(true);
        binder.getFields().map(Component.class::cast).forEach(xva$0 -> features.add(new Component[]{xva$0}));
        Label label = new Label("Features");
        label.addClassNames(new String[]{"label"});
        features.addComponentAtIndex(2, (Component)label);
        this.setSelectionMode((Grid<Person>)grid, GridHelper.getSelectionMode((Grid)grid));
        HorizontalLayout hl = new HorizontalLayout();
        hl.setPadding(false);
        Div toolbarFooterLabel = new Div(new Component[]{new Text("Toolbar Footer")});
        toolbarFooterLabel.getStyle().set("margin", "auto");
        hl.setSizeFull();
        Button toolbarFooterButton = new Button((Component)VaadinIcon.TOOLS.create(), (ComponentEventListener & Serializable)ev -> Notification.show((String)"You clicked a button in the Toolbar Footer"));
        toolbarFooterButton.getThemeNames().add((Object)"small");
        hl.add(new Component[]{toolbarFooterLabel, toolbarFooterButton});
        hl.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        GridHelper.addToolbarFooter((Grid)grid, (Component)hl);
    }

    private Checkbox newCheckbox(String labelText, Grid.SelectionMode ... modes) {
        Checkbox checkbox = new Checkbox(labelText);
        if (modes.length > 0) {
            this.checkboxes.put(checkbox, Arrays.asList(modes));
        }
        return checkbox;
    }

    private void setSelectionMode(Grid<Person> grid, Grid.SelectionMode selectionMode) {
        grid.setSelectionMode(selectionMode);
        GridHelper.setSelectionFilter(grid, (SerializablePredicate)GridHelper.getSelectionFilter(grid));
        this.checkboxes.forEach((checkbox, modes) -> {
            if (modes.contains(selectionMode)) {
                checkbox.getElement().removeAttribute("title");
            } else if (modes.size() == 1) {
                checkbox.getElement().setAttribute("title", String.format("This feature only has effect in %s selection mode", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase()));
            } else if (modes.size() == 2) {
                checkbox.getElement().setAttribute("title", String.format("This feature only has effect in %s and %s selection modes", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase(), ((Grid.SelectionMode)modes.get(1)).toString().toLowerCase()));
            }
        });
        if (selectionMode == Grid.SelectionMode.MULTI) {
            grid.getStyle().remove("--fcgh-noselect-opacity");
        } else {
            grid.getStyle().set("--fcgh-noselect-opacity", "1");
        }
    }

    private void setSelectionFilter(Grid<Person> grid, boolean value) {
        if (value) {
            GridHelper.setSelectionFilter(grid, Person::isActive);
        } else {
            GridHelper.setSelectionFilter(grid, null);
        }
    }

    private boolean hasSelectionFilter(Grid<Person> grid) {
        return GridHelper.getSelectionFilter(grid) != null;
    }

    private void setDenseTheme(Grid<Person> grid, boolean value) {
        if (value) {
            grid.addThemeName("fcGh-dense");
        } else {
            grid.removeThemeName("fcGh-dense");
        }
    }

    private boolean hasDenseTheme(Grid<Person> grid) {
        return grid.hasThemeName("fcGh-dense");
    }

    private void setHeaderHidden(Grid<Person> grid, boolean value) {
        GridHelper.setHeaderVisible(grid, (!value ? 1 : 0) != 0);
    }

    private boolean isHeaderHidden(Grid<Person> grid) {
        return !GridHelper.isHeaderVisible(grid);
    }

    private void setFooterHidden(Grid<Person> grid, boolean value) {
        GridHelper.setFooterVisible(grid, (!value ? 1 : 0) != 0);
    }

    private boolean isFooterHidden(Grid<Person> grid) {
        return !GridHelper.isFooterVisible(grid);
    }

    private void setHeightByRows(Grid<Person> grid, int rows) {
        if (rows > 0) {
            GridHelper.setHeightByRows(grid, (int)rows);
        }
    }

    private int getHeightByRows(Grid<Person> grid) {
        return (int)GridHelper.getHeightByRows(grid);
    }

    private void updateHeightByRowsField(Grid<?> grid, IntegerField field) {
        grid.getElement().executeJs("return", new Serializable[0]).then((SerializableConsumer & Serializable)x -> grid.getElement().executeJs("return window.Vaadin.Flow.fcGridHelperDemoConnector.getViewportRowCount(this)", new Serializable[0]).then(Integer.class, (SerializableConsumer & Serializable)rows -> {
            field.setValue((Number)rows);
            field.setMin(1);
            field.setEnabled(false);
        }));
    }

    private void setHeightByRowsEnabled(Grid<?> grid, boolean value) {
        GridHelper.setHeightMode(grid, (HeightMode)(value ? HeightMode.ROW : HeightMode.CSS));
    }

    private boolean isHeightByRowsEnabled(Grid<?> grid) {
        return GridHelper.getHeightMode(grid) == HeightMode.ROW;
    }

    private boolean isUseLazyData(Grid<Person> grid) {
        return !grid.getDataProvider().isInMemory();
    }

    private void setUseLazyData(Grid<Person> grid, boolean value) {
        if (value) {
            LazyTestData lazyTestData = new LazyTestData();
            grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> lazyTestData.filter(query.getOffset(), query.getPageSize()), (CallbackDataProvider.CountCallback & Serializable)query -> lazyTestData.count());
        } else {
            grid.setItems(TestData.initializeData());
        }
        this.activeCheckboxColumn.refresh();
    }
}

