/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridStylesHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class HeaderFooterStylesHelper
implements Serializable {
    private final GridHelper<?> helper;
    private final Map<Object, GridStylesHelper> styles = new HashMap<Object, GridStylesHelper>();

    GridStylesHelper getStyles(HeaderRow row) {
        Grid<?> grid = this.helper.getGrid();
        if (!grid.getHeaderRows().contains(row)) {
            throw new IllegalArgumentException("HeaderRow does not belong to Grid");
        }
        return this.styles.computeIfAbsent(row, x -> new GridStylesHelperImpl(new HasStyleImpl(row)));
    }

    GridStylesHelper getStyles(FooterRow row) {
        Grid<?> grid = this.helper.getGrid();
        if (!grid.getFooterRows().contains(row)) {
            throw new IllegalArgumentException("FooterRow does not belong to Grid");
        }
        return this.styles.computeIfAbsent(row, x -> new GridStylesHelperImpl(new HasStyleImpl(row)));
    }

    GridStylesHelper getStyles(HeaderRow.HeaderCell cell) {
        Grid<?> grid = this.helper.getGrid();
        if (grid.getHeaderRows().stream().noneMatch(row -> row.getCells().contains(cell))) {
            throw new IllegalArgumentException("HeaderCell does not belong to Grid");
        }
        return this.styles.computeIfAbsent(cell, x -> new GridStylesHelperImpl(new HasStyleImpl(cell)));
    }

    GridStylesHelper getStyles(FooterRow.FooterCell cell) {
        Grid<?> grid = this.helper.getGrid();
        if (grid.getFooterRows().stream().noneMatch(row -> row.getCells().contains(cell))) {
            throw new IllegalArgumentException("FooterCell does not belong to Grid");
        }
        return this.styles.computeIfAbsent(cell, x -> new GridStylesHelperImpl(new HasStyleImpl(cell)));
    }

    public HeaderFooterStylesHelper(GridHelper<?> helper) {
        this.helper = helper;
    }

    private final class HasStyleImpl
    implements HasStyle {
        private final ClassList classList;

        HasStyleImpl(HeaderRow row) {
            this(headerFooterStylesHelper.new HeaderRowSelector(row));
        }

        HasStyleImpl(FooterRow row) {
            this(headerFooterStylesHelper.new FooterRowSelector(row));
        }

        HasStyleImpl(HeaderRow.HeaderCell cell) {
            this(headerFooterStylesHelper.new HeaderCellSelector(cell));
        }

        HasStyleImpl(FooterRow.FooterCell cell) {
            this(headerFooterStylesHelper.new FooterCellSelector(cell));
        }

        private HasStyleImpl(SelectorSupplier selectorSupplier) {
            this.classList = new ClassListImpl(selectorSupplier);
        }

        public Element getElement() {
            throw new UnsupportedOperationException();
        }

        public ClassList getClassNames() {
            return this.classList;
        }

        public void setClassName(String className) {
            this.classList.clear();
            this.addClassName(className);
        }

        public String getClassName() {
            return StringUtils.trimToNull((String)this.classList.stream().collect(Collectors.joining(" ")));
        }
    }

    private final class GridStylesHelperImpl
    implements GridStylesHelper {
        final HasStyle classList;

        public GridStylesHelperImpl(HasStyle classList) {
            this.classList = classList;
        }

        @Override
        public void addClassName(String className) {
            this.classList.addClassName(className);
        }

        @Override
        public boolean removeClassName(String className) {
            return this.classList.removeClassName(className);
        }

        @Override
        public void setClassName(String className) {
            this.classList.setClassName(className);
        }

        @Override
        public String getClassName() {
            return this.classList.getClassName();
        }

        @Override
        public void setClassName(String className, boolean set) {
            this.classList.setClassName(className, set);
        }

        @Override
        public boolean hasClassName(String className) {
            return this.classList.hasClassName(className);
        }

        @Override
        public void addClassNames(String ... classNames) {
            this.classList.addClassNames(classNames);
        }

        @Override
        public void removeClassNames(String ... classNames) {
            this.classList.removeClassNames(classNames);
        }
    }

    private static class WrappedIterator
    implements Iterator<String> {
        private final Iterator<String> it;
        private String last;

        protected void onRemove(String last) {
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public String next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.it.remove();
            this.onRemove(this.last);
        }

        public WrappedIterator(Iterator<String> it) {
            this.it = it;
        }
    }

    private final class ClassListImpl
    extends AbstractSet<String>
    implements ClassList {
        final List<String> classes = new ArrayList<String>();
        final SelectorSupplier selectorSupplier;

        private ClassListImpl(SelectorSupplier selectorSupplier) {
            this.selectorSupplier = selectorSupplier;
            Grid<?> grid = HeaderFooterStylesHelper.this.helper.getGrid();
            grid.addAttachListener((ComponentEventListener & Serializable)ev -> {
                if (!this.classes.isEmpty()) {
                    String classNames = this.classes.stream().collect(Collectors.joining(" "));
                    this.executeJs("className=$0", classNames, true);
                }
            });
        }

        private void validateClassName(String className) {
            for (int i = 0; i < className.length(); ++i) {
                if (!Character.isWhitespace(className.charAt(i))) continue;
                throw new IllegalArgumentException("The classname provided contains HTML space characters, which are not valid in tokens");
            }
        }

        @Override
        public boolean add(String className) {
            this.validateClassName(className);
            if (this.classes.add(className)) {
                this.beforeResponse("classList.add($0)", className);
                return true;
            }
            return false;
        }

        private void beforeResponse(String expression, String parameter) {
            Grid<?> grid = HeaderFooterStylesHelper.this.helper.getGrid();
            grid.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)grid, (SerializableConsumer & Serializable)ctx -> this.executeJs(expression, parameter, false)));
        }

        private void executeJs(String expression, String parameter, boolean deferred) {
            Serializable[] selector = this.selectorSupplier.getSelector();
            if (selector != null) {
                expression = selector[0] + "." + (String)expression;
                expression = "var i=$1, j=$2, h;if ((h=this.getElementsByTagName('vaadin-grid-flow-selection-column')[0]) && !h.hidden) ++j;" + (String)expression;
                if (deferred) {
                    expression = String.format("setTimeout(()=>{%s})", expression);
                }
                selector[0] = parameter;
                HeaderFooterStylesHelper.this.helper.getGrid().getElement().executeJs((String)expression, selector);
            }
        }

        @Override
        public int size() {
            return this.classes.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new WrappedIterator(this.classes.iterator()){

                @Override
                protected void onRemove(String className) {
                    ClassListImpl.this.beforeResponse("classList.remove($0)", className);
                }
            };
        }
    }

    private final class FooterCellSelector
    extends CellSelector<FooterRow, FooterRow.FooterCell> {
        final FooterRow.FooterCell cell;
        final FooterRowSelector rowSelector;

        public FooterCellSelector(FooterRow.FooterCell cell) {
            this.cell = cell;
            for (FooterRow row : HeaderFooterStylesHelper.this.helper.getGrid().getFooterRows()) {
                if (!row.getCells().contains(cell)) continue;
                this.rowSelector = new FooterRowSelector(row);
                return;
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected FooterRow.FooterCell getCell(FooterRow row, Grid.Column<?> c) {
            return (FooterRow.FooterCell)row.getCell(c);
        }

        @Override
        public FooterRow.FooterCell getCell() {
            return this.cell;
        }

        public FooterRowSelector getRowSelector() {
            return this.rowSelector;
        }
    }

    private final class HeaderCellSelector
    extends CellSelector<HeaderRow, HeaderRow.HeaderCell> {
        final HeaderRow.HeaderCell cell;
        final HeaderRowSelector rowSelector;

        public HeaderCellSelector(HeaderRow.HeaderCell cell) {
            this.cell = cell;
            for (HeaderRow row : HeaderFooterStylesHelper.this.helper.getGrid().getHeaderRows()) {
                if (!row.getCells().contains(cell)) continue;
                this.rowSelector = new HeaderRowSelector(row);
                return;
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected HeaderRow.HeaderCell getCell(HeaderRow row, Grid.Column<?> c) {
            return (HeaderRow.HeaderCell)row.getCell(c);
        }

        @Override
        public HeaderRow.HeaderCell getCell() {
            return this.cell;
        }

        public HeaderRowSelector getRowSelector() {
            return this.rowSelector;
        }
    }

    private abstract class CellSelector<ROW, CELL>
    implements SelectorSupplier {
        private CellSelector() {
        }

        protected abstract RowSelector<ROW> getRowSelector();

        protected abstract CELL getCell(ROW var1, Grid.Column<?> var2);

        protected abstract CELL getCell();

        private int getColumnIndex(int rowIndex) {
            ROW row = this.getRowSelector().getRow();
            int j = -1;
            for (Grid.Column c : HeaderFooterStylesHelper.this.helper.getGrid().getColumns()) {
                if (!c.isVisible()) continue;
                ++j;
                if (this.getCell(row, c) != this.getCell()) continue;
                break;
            }
            return j;
        }

        @Override
        public final Serializable[] getSelector() {
            Serializable[] serializableArray;
            int i = this.getRowSelector().getRowIndex();
            int j = this.getColumnIndex(i);
            if (j < 0) {
                serializableArray = null;
            } else {
                Serializable[] serializableArray2 = new Serializable[3];
                serializableArray2[0] = this.getSelectorTemplate();
                serializableArray2[1] = Integer.valueOf(i);
                serializableArray = serializableArray2;
                serializableArray2[2] = Integer.valueOf(j + 1);
            }
            return serializableArray;
        }

        protected String getSelectorTemplate() {
            return this.getRowSelector().getSelectorTemplate() + ".querySelector(`th:nth-child(${j})`)";
        }
    }

    private final class FooterRowSelector
    extends RowSelector<FooterRow> {
        private final FooterRow row;

        @Override
        protected List<FooterRow> getRows() {
            return HeaderFooterStylesHelper.this.helper.getGrid().getFooterRows();
        }

        @Override
        protected String getSelectorTemplate() {
            return "this.shadowRoot.querySelectorAll('tfoot tr:not([hidden])')[i]";
        }

        public FooterRowSelector(FooterRow row) {
            this.row = row;
        }

        @Override
        public FooterRow getRow() {
            return this.row;
        }
    }

    private final class HeaderRowSelector
    extends RowSelector<HeaderRow> {
        final HeaderRow row;

        @Override
        protected List<HeaderRow> getRows() {
            return HeaderFooterStylesHelper.this.helper.getGrid().getHeaderRows();
        }

        @Override
        protected String getSelectorTemplate() {
            return "this.shadowRoot.querySelectorAll('thead tr:not([hidden])')[i]";
        }

        public HeaderRowSelector(HeaderRow row) {
            this.row = row;
        }

        @Override
        public HeaderRow getRow() {
            return this.row;
        }
    }

    private abstract class RowSelector<ROW>
    implements SelectorSupplier {
        protected abstract List<ROW> getRows();

        protected abstract String getSelectorTemplate();

        protected abstract ROW getRow();

        public int getRowIndex() {
            int i = -1;
            for (ROW row : this.getRows()) {
                ++i;
                if (row != this.getRow()) continue;
                break;
            }
            return i;
        }

        @Override
        public final Serializable[] getSelector() {
            Serializable[] serializableArray;
            int i = this.getRowIndex();
            if (i < 0) {
                serializableArray = null;
            } else {
                Serializable[] serializableArray2 = new Serializable[2];
                serializableArray2[0] = this.getSelectorTemplate();
                serializableArray = serializableArray2;
                serializableArray2[1] = Integer.valueOf(i);
            }
            return serializableArray;
        }
    }

    @FunctionalInterface
    private static interface SelectorSupplier
    extends Serializable {
        public Serializable[] getSelector();
    }
}

