/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelpersDemoView;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Column Toggle Menu")
@DemoSource
@Route(value="grid-helpers/column-toggle-menu", layout=GridHelpersDemoView.class)
public class ColumnToggleMenuDemo
extends Div {
    public ColumnToggleMenuDemo() {
        this.setSizeFull();
        Grid grid = new Grid();
        grid.setItems(TestData.initializeData());
        Grid.Column firstNameColumn = grid.addColumn(Person::getFirstName).setHeader("First name");
        Grid.Column lastNameColumn = grid.addColumn(Person::getLastName).setHeader("Last name");
        Grid.Column countryColumn = grid.addColumn(Person::getCountry).setHeader("Country");
        GridHelper.setHidingToggleCaption((Grid.Column)firstNameColumn, (String)"First name");
        GridHelper.setHidingToggleCaption((Grid.Column)lastNameColumn, (String)"Last name");
        GridHelper.setHidingToggleCaption((Grid.Column)countryColumn, (String)"Country");
        GridHelper.setColumnToggleVisible((Grid)grid, (boolean)this.isVisible());
        GridHelper.addColumnToggleListener((Grid)grid, (ComponentEventListener & Serializable)ev -> {
            String caption = GridHelper.getHidingToggleCaption((Grid.Column)ev.getColumn());
            String message = caption + " is now " + (ev.getColumn().isVisible() ? "visible" : "invisible");
            new Notification(message).open();
        });
        grid.setHeightFull();
        this.add(new Component[]{grid});
    }
}

