/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridResponsiveStepEvent;
import com.flowingcode.vaadin.addons.gridhelpers.ResponsiveGridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class GridResponsiveStep<T>
implements Serializable {
    private int minWidth;
    private final ResponsiveGridHelper<T> helper;
    private final Map<Grid.Column<T>, Boolean> columns = new HashMap<Grid.Column<T>, Boolean>();
    private Boolean allColumnsVisible;
    private Renderer<T> itemDetailsRenderer;
    private boolean itemDetailsRendererSet;
    private final Map<SerializableConsumer<GridResponsiveStepEvent>, Boolean> listeners = new LinkedHashMap<SerializableConsumer<GridResponsiveStepEvent>, Boolean>();

    GridResponsiveStep() {
        this.minWidth = -1;
        this.helper = null;
    }

    GridResponsiveStep(int minWidth, @NonNull ResponsiveGridHelper<T> helper) {
        if (helper == null) {
            throw new NullPointerException("helper is marked non-null but is null");
        }
        if (minWidth < 0) {
            throw new IllegalArgumentException();
        }
        this.minWidth = minWidth;
        this.helper = helper;
    }

    private void requireRefresh() {
        if (this.helper != null) {
            this.helper.requireRefresh(this);
        }
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    void accumulate(GridResponsiveStep<T> step) {
        if (this.helper != null || step.minWidth <= this.minWidth) {
            throw new IllegalArgumentException();
        }
        this.minWidth = step.minWidth;
        if (step.itemDetailsRendererSet) {
            this.itemDetailsRendererSet = true;
            this.itemDetailsRenderer = step.itemDetailsRenderer;
        }
        if (step.allColumnsVisible != null) {
            this.columns.keySet().forEach(c -> this.columns.put((Grid.Column<T>)c, step.allColumnsVisible));
        }
        this.itemDetailsRenderer = step.itemDetailsRenderer;
        this.columns.putAll(step.columns);
        this.listeners.entrySet().removeIf(e -> (Boolean)e.getValue() == false);
        this.listeners.putAll(step.listeners);
    }

    void apply(Grid<T> grid) {
        if (this.helper != null) {
            throw new IllegalStateException();
        }
        boolean hasChanges = false;
        if (this.itemDetailsRendererSet) {
            grid.setItemDetailsRenderer(this.itemDetailsRenderer);
            grid.setDetailsVisibleOnClick(this.itemDetailsRenderer != null);
        }
        for (Map.Entry<Grid.Column<T>, Boolean> e : this.columns.entrySet()) {
            Grid.Column<T> c = e.getKey();
            if (e.getValue().equals(c.isVisible()) || GridHelper.isMenuToggleColumn(c)) continue;
            e.getKey().setVisible(e.getValue().booleanValue());
            hasChanges = true;
        }
        if (hasChanges && GridHelper.isColumnToggleVisible(grid)) {
            GridHelper.setColumnToggleVisible(grid, true);
        }
        GridResponsiveStepEvent ev = new GridResponsiveStepEvent(grid, this.minWidth);
        this.listeners.keySet().forEach(listener -> listener.accept((Object)ev));
    }

    public GridResponsiveStep<T> setItemDetailsRenderer(Renderer<T> renderer) {
        this.itemDetailsRenderer = renderer;
        this.itemDetailsRendererSet = true;
        this.requireRefresh();
        return this;
    }

    public <C extends Component> GridResponsiveStep<T> setItemDetailsRenderer(@NonNull SerializableFunction<T, C> componentFunction) {
        if (componentFunction == null) {
            throw new NullPointerException("componentFunction is marked non-null but is null");
        }
        return this.setItemDetailsRenderer((Renderer<T>)new ComponentRenderer(componentFunction));
    }

    public GridResponsiveStep<T> setColumns(Grid.Column<?> ... columnsToShow) {
        this.hideAll();
        this.show(columnsToShow);
        return this;
    }

    public GridResponsiveStep<T> setColumns(List<Grid.Column<T>> columnsToShow) {
        return this.setColumns((Grid.Column[])columnsToShow.toArray(Grid.Column[]::new));
    }

    public GridResponsiveStep<T> show(Grid.Column<?> ... columnsToShow) {
        return this.show(Arrays.asList(columnsToShow));
    }

    public GridResponsiveStep<T> show(List<Grid.Column<T>> columnsToShow) {
        return this.setVisibility(columnsToShow, true);
    }

    public GridResponsiveStep<T> hide(Grid.Column<?> ... columnsToHide) {
        return this.hide(Arrays.asList(columnsToHide));
    }

    public GridResponsiveStep<T> hide(List<Grid.Column<T>> columnsToHide) {
        return this.setVisibility(columnsToHide, false);
    }

    private GridResponsiveStep<T> setVisibility(List<Grid.Column<T>> columnsToSet, Boolean value) {
        if (this.helper != null && !this.helper.getGrid().getColumns().containsAll(columnsToSet)) {
            throw new IllegalArgumentException("Some columns are not contained in the grid");
        }
        columnsToSet.forEach(c -> this.columns.put((Grid.Column<T>)c, value));
        this.requireRefresh();
        return this;
    }

    public GridResponsiveStep<T> hideAll() {
        this.columns.clear();
        this.allColumnsVisible = false;
        this.requireRefresh();
        return this;
    }

    public GridResponsiveStep<T> showAll() {
        this.columns.clear();
        this.allColumnsVisible = true;
        this.requireRefresh();
        return this;
    }

    public GridResponsiveStepListenerRegistration addListener(final @NonNull SerializableConsumer<GridResponsiveStepEvent> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.listeners.put(listener, Boolean.FALSE);
        if (this.minWidth == this.helper.getCurrentMinWidth()) {
            listener.accept((Object)new GridResponsiveStepEvent(this.helper.getGrid(), this.minWidth));
        }
        return new GridResponsiveStepListenerRegistration(){
            {
                if (GridResponsiveStep.this.minWidth == GridResponsiveStep.this.helper.getCurrentMinWidth()) {
                    this.fireStepEvent();
                }
            }

            private void fireStepEvent() {
                listener.accept((Object)new GridResponsiveStepEvent(GridResponsiveStep.this.helper.getGrid(), GridResponsiveStep.this.helper.getCurrentMinWidth()));
            }

            public void remove() {
                GridResponsiveStep.this.listeners.remove(listener);
            }

            @Override
            public GridResponsiveStepListenerRegistration cummulative() {
                GridResponsiveStep.this.listeners.computeIfPresent((SerializableConsumer<GridResponsiveStepEvent>)listener, (k, cummulative) -> {
                    if (!cummulative.booleanValue() && GridResponsiveStep.this.minWidth < GridResponsiveStep.this.helper.getCurrentMinWidth()) {
                        this.fireStepEvent();
                    }
                    return Boolean.TRUE;
                });
                return this;
            }
        };
    }

    public void remove() {
        this.helper.remove(this);
    }

    public Renderer<T> getItemDetailsRenderer() {
        return this.itemDetailsRenderer;
    }

    public static interface GridResponsiveStepListenerRegistration
    extends Registration {
        public GridResponsiveStepListenerRegistration cummulative();
    }
}

