/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.ColumnToggleEvent;
import com.flowingcode.vaadin.addons.gridhelpers.ColumnToggleHelper;
import com.flowingcode.vaadin.addons.gridhelpers.EmptyLabelGridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.EnhancedSelectionGridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.FooterToolbarGridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelperClassNameGenerator;
import com.flowingcode.vaadin.addons.gridhelpers.SelectionColumnHelper;
import com.flowingcode.vaadin.addons.gridhelpers.SelectionFilterHelper;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsModule(value="./fcGridHelper/connector.js")
@CssImport.Container(value={@CssImport(value="./fcGridHelper/vaadin-menu-bar.css", themeFor="vaadin-menu-bar"), @CssImport(value="./fcGridHelper/vaadin-grid.css", themeFor="vaadin-grid"), @CssImport(value="./fcGridHelper/vaadin-context-menu-item.css", themeFor="vaadin-context-menu-item"), @CssImport(value="./fcGridHelper/vaadin-context-menu-list-box.css", themeFor="vaadin-context-menu-list-box")})
public final class GridHelper<T>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(GridHelper.class);
    private static final String ARROW_SELECTION_PROPERTY = "_fcghArrowSelection";
    public static final String GRID_STYLES = "./fcGridHelper/vaadin-grid.css";
    public static final String DENSE_THEME = "fcGh-dense";
    private final Grid<T> grid;
    private final GridHelperClassNameGenerator<T> helperClassNameGenerator;
    private boolean selectOnClick;
    private final SelectionColumnHelper selectionColumnHelper = new SelectionColumnHelper(this);
    private final SelectionFilterHelper<T> selectionFilterHelper = new SelectionFilterHelper(this);
    private final ColumnToggleHelper<T> columnToggleHelper = new ColumnToggleHelper(this);
    private final EmptyLabelGridHelper emptyLabel = new EmptyLabelGridHelper(this);
    private final FooterToolbarGridHelper footerToolbar = new FooterToolbarGridHelper(this);
    private final EnhancedSelectionGridHelper<T> enhancedSelectionGridHelper = new EnhancedSelectionGridHelper(this);

    protected void setHelperClassNameGenerator(Class<?> clazz, SerializableFunction<T, String> generator) {
        GridHelper.getHelper(this.grid).helperClassNameGenerator.setHelperClassNameGenerator(clazz, generator);
        this.grid.getDataCommunicator().reset();
    }

    private GridHelper(Grid<T> grid) {
        this.grid = grid;
        this.helperClassNameGenerator = new GridHelperClassNameGenerator();
        this.setClassNameGenerator(grid.getClassNameGenerator());
        grid.addItemClickListener(this::onItemClick);
        grid.addAttachListener(this::onAttach);
    }

    private static <T> GridHelper<T> getHelper(Grid.Column<T> column) {
        return GridHelper.getHelper(column.getGrid());
    }

    private static <T> GridHelper<T> getHelper(Grid<T> grid) {
        GridHelper<T> helper = (GridHelper<T>)ComponentUtil.getData(grid, GridHelper.class);
        if (helper == null) {
            helper = new GridHelper<T>(grid);
            ComponentUtil.setData(grid, GridHelper.class, helper);
        }
        return helper;
    }

    private void initConnector() {
        ((UI)this.grid.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached Grid"))).getPage().executeJs("window.Vaadin.Flow.fcGridHelperConnector.initLazy($0)", new Serializable[]{this.grid.getElement()});
    }

    private void onAttach(AttachEvent event) {
        this.initConnector();
        this.selectionColumnHelper.onAttach();
    }

    private void onItemClick(ItemClickEvent<T> event) {
        Object item = event.getItem();
        if (this.selectOnClick && GridHelper.getSelectionMode(this.grid) == Grid.SelectionMode.MULTI) {
            if (!this.selectionFilterHelper.canSelect(item)) {
                return;
            }
            if (this.grid.getSelectedItems().contains(item)) {
                this.grid.deselect(item);
            } else {
                this.grid.select(item);
            }
        }
    }

    public static Grid.SelectionMode getSelectionMode(Grid<?> grid) {
        GridSelectionModel model = grid.getSelectionModel();
        if (model instanceof GridSingleSelectionModel) {
            return Grid.SelectionMode.SINGLE;
        }
        if (model instanceof GridMultiSelectionModel) {
            return Grid.SelectionMode.MULTI;
        }
        return Grid.SelectionMode.NONE;
    }

    public void setClassNameGenerator(SerializableFunction<T, String> classNameGenerator) {
        this.grid.setClassNameGenerator(this.helperClassNameGenerator);
        if (classNameGenerator instanceof GridHelperClassNameGenerator) {
            this.helperClassNameGenerator.setGridClassNameGenerator(((GridHelperClassNameGenerator)classNameGenerator).getGridClassNameGenerator());
        } else {
            this.helperClassNameGenerator.setGridClassNameGenerator(classNameGenerator);
        }
    }

    public static void setSelectOnClick(Grid<?> grid, boolean selectOnClick) {
        GridHelper.getHelper(grid).selectOnClick = selectOnClick;
        if (selectOnClick && GridHelper.isEnhancedSelectionEnabled(grid)) {
            logger.warn("Please disable Enhanced Selection feature when enabling Select On Click to avoid unwanted side effects.");
        }
    }

    public static boolean isSelectOnClick(Grid<?> grid) {
        return GridHelper.getHelper(grid).selectOnClick;
    }

    public static void setArrowSelectionEnabled(Grid<?> grid, boolean value) {
        GridHelper.getHelper(grid);
        grid.getElement().setProperty(ARROW_SELECTION_PROPERTY, value);
        if (value && GridHelper.isEnhancedSelectionEnabled(grid)) {
            logger.warn("Please disable Enhanced Selection feature when enabling Arrow Selection to avoid unwanted side effects.");
        }
    }

    public static boolean isArrowSelectionEnabled(Grid<?> grid) {
        return grid.getElement().getProperty(ARROW_SELECTION_PROPERTY, false);
    }

    public static void setSelectionColumnHidden(Grid<?> grid, boolean value) {
        GridHelper.getHelper(grid).selectionColumnHelper.setSelectionColumnHidden(value);
    }

    @Deprecated
    public static void setSelectionColumnFrozen(Grid<?> grid, boolean value) {
        if (GridHelper.getSelectionMode(grid) == Grid.SelectionMode.MULTI) {
            ((GridMultiSelectionModel)grid.getSelectionModel()).setSelectionColumnFrozen(value);
        }
    }

    public static boolean isSelectionColumnHidden(Grid<?> grid) {
        return GridHelper.getHelper(grid).selectionColumnHelper.isSelectionColumnHidden();
    }

    @Deprecated
    public static boolean isSelectionColumnFrozen(Grid<?> grid) {
        return GridHelper.getSelectionMode(grid) == Grid.SelectionMode.MULTI && ((GridMultiSelectionModel)grid.getSelectionModel()).isSelectionColumnFrozen();
    }

    public static <T> void setSelectionFilter(Grid<T> grid, SerializablePredicate<T> predicate) {
        GridHelper.getHelper(grid).selectionFilterHelper.setSelectionFilter(predicate);
    }

    public static <T> SerializablePredicate<T> getSelectionFilter(Grid<T> grid) {
        return GridHelper.getHelper(grid).selectionFilterHelper.getSelectionFilter();
    }

    public static void setColumnToggleVisible(Grid<?> grid, boolean visible) {
        GridHelper.getHelper(grid).columnToggleHelper.setColumnToggleVisible(visible);
    }

    public static boolean isColumnToggleVisible(Grid<?> grid) {
        return GridHelper.getHelper(grid).columnToggleHelper.isColumnToggleVisible();
    }

    public static <T> boolean isHidable(Grid.Column<T> column) {
        return GridHelper.getHelper(column.getGrid()).columnToggleHelper.isHidable(column);
    }

    public static <T> Grid.Column<T> setHidable(Grid.Column<T> column, boolean hidable) {
        GridHelper.getHelper(column.getGrid()).columnToggleHelper.setHidable(column, hidable);
        return column;
    }

    public static <T> Registration addColumnToggleListener(Grid<T> grid, ComponentEventListener<ColumnToggleEvent<T>> listener) {
        return GridHelper.getHelper(grid).columnToggleHelper.addColumnToggleListener(listener);
    }

    public static <T> void setHidingToggleCaption(Grid.Column<T> column, String caption) {
        GridHelper.getHelper(column.getGrid()).columnToggleHelper.setHidingToggleCaption(column, caption);
    }

    public static <T> String getHidingToggleCaption(Grid.Column<T> column) {
        return GridHelper.getHelper(column.getGrid()).columnToggleHelper.getHidingToggleCaption(column);
    }

    public static boolean isMenuToggleColumn(Grid.Column<?> column) {
        return column == GridHelper.getHelper(column).columnToggleHelper.getMenuToggleColumn();
    }

    public static void setEmptyGridLabel(Grid<?> grid, Component component) {
        GridHelper.getHelper(grid).emptyLabel.setEmptyGridLabel(component);
    }

    public static Component getEmptyGridLabel(Grid<?> grid) {
        return GridHelper.getHelper(grid).emptyLabel.getEmptyGridLabel();
    }

    public static void addToolbarFooter(Grid<?> grid, Component toolBar) {
        GridHelper.getHelper(grid).footerToolbar.setFooterToolbar(toolBar);
    }

    @Deprecated
    public static String getHeader(Grid<?> grid, Grid.Column<?> column) {
        return column.getHeaderText();
    }

    @Deprecated
    public static String getFooter(Grid<?> grid, Grid.Column<?> column) {
        return column.getFooterText();
    }

    public static final void setEnhancedSelectionEnabled(Grid<?> grid, boolean enabled) {
        if (enabled) {
            GridHelper.getHelper(grid).enhancedSelectionGridHelper.enableEnhancedSelection();
            if (GridHelper.isArrowSelectionEnabled(grid) || GridHelper.isSelectOnClick(grid)) {
                logger.warn("Please disable Arrow Selection and Select On Click features when enabling Enhanced Selection to avoid unwanted side effects.");
            }
        } else {
            GridHelper.getHelper(grid).enhancedSelectionGridHelper.disableEnhancedSelection();
        }
    }

    public static boolean isEnhancedSelectionEnabled(Grid<?> grid) {
        return GridHelper.getHelper(grid).enhancedSelectionGridHelper.isEnhancedSelectionEnabled();
    }

    Grid<T> getGrid() {
        return this.grid;
    }
}

