/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.it.AbstractViewTest;
import com.flowingcode.vaadin.addons.gridhelpers.it.GridHelperElement;
import com.flowingcode.vaadin.addons.gridhelpers.it.IntegrationViewCallables;
import com.flowingcode.vaadin.addons.gridhelpers.it.MyGridElement;
import com.flowingcode.vaadin.testbench.rpc.HasRpcSupport;
import com.flowingcode.vaadin.testbench.rpc.JsonArrayList;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.testbench.GridElement;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SelectionFilterIT
extends AbstractViewTest
implements HasRpcSupport {
    IntegrationViewCallables $server = (IntegrationViewCallables)this.createCallableProxy(IntegrationViewCallables.class);
    GridHelperElement grid;

    public SelectionFilterIT() {
        super("it");
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.grid = new GridHelperElement((GridElement)this.$(MyGridElement.class).waitForFirst());
    }

    @SafeVarargs
    private static <T> Matcher<? super JsonArrayList<T>> equalToList(T ... items) {
        return Matchers.equalTo(Arrays.asList(items));
    }

    @Test
    public void testFilteredSelectionMulti() {
        this.$server.setSelectionMode(Grid.SelectionMode.MULTI);
        this.$server.setSelectionFilterEnabled(true);
        this.grid.select(0);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0));
        this.grid.select(1);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0));
        this.grid.select(2);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0, 2));
    }

    @Test
    public void testFilteredSelectionSingle() {
        this.$server.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.$server.setSelectionFilterEnabled(true);
        this.grid.select(0);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0));
        this.grid.select(1);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0));
        this.grid.select(2);
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(2));
    }

    @Test
    public void testUnfilteredSelection() {
        this.$server.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.$server.setSelectionFilterEnabled(true);
        this.$server.setSelectionFilterEnabled(false);
        this.grid.getCell(0, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(0));
        this.grid.getCell(1, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectionFilterIT.equalToList(1));
    }
}

