/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.flowingcode.vaadin.addons.gridhelpers.it.IntegrationViewCallables;
import com.flowingcode.vaadin.testbench.rpc.JsonArrayList;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@Route(value="it")
public class IntegrationView
extends Div
implements IntegrationViewCallables {
    private Grid<Person> grid;
    private Integer toggledColumn;

    public IntegrationView() {
        this.setSizeFull();
        this.getElement().getStyle().set("flex-grow", "1");
        this.grid = new Grid();
        this.grid.addColumn(Person::getLastName).setHeader("Last name");
        this.grid.addColumn(Person::getFirstName).setHeader("First name");
        this.grid.addColumn((ValueProvider & Serializable)p -> p.isActive() ? "Yes" : "No").setHeader("Active");
        this.grid.addColumn(Person::getTitle).setHeader("Title");
        this.grid.addColumn(Person::getCountry).setHeader("Country");
        this.grid.addColumn(Person::getCity).setHeader("City");
        this.grid.addColumn(Person::getStreetAddress).setHeader("Street Address");
        this.grid.addColumn(Person::getPhoneNumber).setHeader("Phone Number");
        this.grid.addColumn(Person::getEmailAddress).setHeader("Email Address");
        this.grid.getColumns().forEach(c -> c.setAutoWidth(true));
        this.grid.getColumns().forEach(c -> GridHelper.setHidable((Grid.Column)c, (boolean)true));
        this.grid.setItems(TestData.initializeData());
        GridHelper.addColumnToggleListener(this.grid, (ComponentEventListener & Serializable)ev -> {
            this.toggledColumn = this.grid.getColumns().indexOf(ev.getColumn());
        });
        this.add(new Component[]{this.grid});
    }

    private List<Person> getItems() {
        return this.grid.getListDataView().getItems().collect(Collectors.toList());
    }

    @Override
    @ClientCallable
    public void setColumnToggleVisible(boolean value) {
        GridHelper.setColumnToggleVisible(this.grid, (boolean)value);
    }

    @Override
    @ClientCallable
    public void setSelectOnClick(boolean value) {
        GridHelper.setSelectOnClick(this.grid, (boolean)value);
    }

    @Override
    @ClientCallable
    public void setSelectionMode(Grid.SelectionMode selectionMode) {
        this.grid.setSelectionMode(selectionMode);
    }

    @Override
    @ClientCallable
    public JsonArrayList<Integer> getSelectedRows() {
        List<Person> items = this.getItems();
        return JsonArrayList.fromIntegers((Iterable)this.grid.getSelectedItems().stream().map(items::indexOf).sorted().collect(Collectors.toList()));
    }

    @Override
    @ClientCallable
    public void setHidable(int columnIndex, boolean hidable) {
        Grid.Column column = (Grid.Column)this.grid.getColumns().get(columnIndex);
        GridHelper.setHidable((Grid.Column)column, (boolean)hidable);
    }

    @Override
    @ClientCallable
    public void setSelectionFilterEnabled(boolean enabled) {
        if (enabled) {
            List<Person> items = this.getItems();
            GridHelper.setSelectionFilter(this.grid, (SerializablePredicate & Serializable)item -> items.indexOf(item) % 2 == 0);
        } else {
            GridHelper.setSelectionFilter(this.grid, null);
        }
    }

    @Override
    @ClientCallable
    public void setColumnHeader(int i, String header) {
        ((Grid.Column)this.grid.getColumns().get(i)).setHeader(header);
    }

    @Override
    @ClientCallable
    public void setHidingToggleCaption(int i, String header) {
        Grid.Column col = (Grid.Column)this.grid.getColumns().get(i);
        GridHelper.setHidingToggleCaption((Grid.Column)col, (String)header);
    }

    @Override
    @ClientCallable
    public void setEmptyGridLabel(String label) {
        Span span = new Span(label);
        span.setVisible(false);
        this.add(new Component[]{span});
        GridHelper.setEmptyGridLabel(this.grid, (Component)span);
    }

    @Override
    @ClientCallable
    public void setSelectionColumnHidden(boolean b) {
        GridHelper.setSelectionColumnHidden(this.grid, (boolean)b);
    }

    @Override
    @ClientCallable
    public void setSelectionColumnFrozen(boolean b) {
        GridHelper.setSelectionColumnFrozen(this.grid, (boolean)b);
    }

    @Override
    @ClientCallable
    public void setArrowSelectionEnabled(boolean b) {
        GridHelper.setArrowSelectionEnabled(this.grid, (boolean)b);
    }

    @Override
    @ClientCallable
    public void addToolbarFooter(String footer) {
        GridHelper.addToolbarFooter(this.grid, (Component)new Span(footer));
    }

    @Override
    @ClientCallable
    public void removeAllItems() {
        ((ListDataProvider)this.grid.getDataProvider()).getItems().clear();
        this.grid.getDataProvider().refreshAll();
    }

    @Override
    @ClientCallable
    public Integer getToggledColumn() {
        return this.toggledColumn;
    }
}

