/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.it.MyGridElement;
import com.vaadin.flow.component.checkbox.testbench.CheckboxElement;
import com.vaadin.flow.component.grid.testbench.GridElement;
import com.vaadin.flow.component.menubar.testbench.MenuBarElement;
import com.vaadin.testbench.ElementQuery;
import com.vaadin.testbench.TestBenchElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

public class GridHelperElement
extends MyGridElement {
    public GridHelperElement(GridElement e) {
        this.init(e.getWrappedElement(), e.getCommandExecutor());
    }

    public Object executeScript(String script, Object ... arguments) {
        script = String.format("return function(arguments){arguments.pop(); %s}.bind(arguments[arguments.length-1])([].slice.call(arguments))", script);
        arguments = Arrays.copyOf(arguments, arguments.length + 1);
        arguments[arguments.length - 1] = this;
        return this.getCommandExecutor().executeScript(script, arguments);
    }

    private MenuBarElement getMenuBar() {
        return (MenuBarElement)this.$(MenuBarElement.class).waitForFirst(0L);
    }

    public TestBenchElement getColumnToggleButton() {
        try {
            return (TestBenchElement)this.getMenuBar().getButtons().get(0);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public List<CheckboxElement> getColumnToggleElements() {
        try {
            return new ElementQuery(TestBenchElement.class, "vaadin-context-menu-overlay").context((SearchContext)this.getDriver()).waitForFirst(0L).$(CheckboxElement.class).all();
        }
        catch (NoSuchElementException e) {
            return Collections.emptyList();
        }
    }

    public TestBenchElement getToolbarFooter() {
        List elements = this.findElements(By.cssSelector((String)"[fcgh-footer]"));
        return elements.stream().findFirst().orElse(null);
    }

    public TestBenchElement getSelectionCheckbox(int rowIndex) {
        TestBenchElement cell = this.getSlottedCell((WebElement)this.getRow(rowIndex));
        List elements = cell.findElements(By.tagName((String)"vaadin-checkbox"));
        return elements.stream().findFirst().orElse(null);
    }

    private TestBenchElement getSlottedCell(WebElement e) {
        String slot = e.findElement(By.tagName((String)"slot")).getAttribute("name");
        return this.findElement(By.cssSelector((String)String.format("[slot='%s']", slot)));
    }
}

