/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.it.AbstractViewTest;
import com.flowingcode.vaadin.addons.gridhelpers.it.GridHelperElement;
import com.flowingcode.vaadin.addons.gridhelpers.it.IntegrationViewCallables;
import com.flowingcode.vaadin.testbench.rpc.HasRpcSupport;
import com.vaadin.flow.component.grid.testbench.GridElement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ColumnToggleIT
extends AbstractViewTest
implements HasRpcSupport {
    IntegrationViewCallables $server = (IntegrationViewCallables)this.createCallableProxy(IntegrationViewCallables.class);
    GridHelperElement grid;

    public ColumnToggleIT() {
        super("it");
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.grid = new GridHelperElement((GridElement)this.$(GridElement.class).waitForFirst());
    }

    @Test
    public void testColumnToggleVisible() {
        int nColumns = this.grid.getVisibleColumns().size();
        Assert.assertNull((String)"ColumnToggle should be absent", (Object)this.grid.getColumnToggleButton());
        this.$server.setColumnToggleVisible(true);
        Assert.assertNotNull((String)"ColumnToggle should be present", (Object)this.grid.getColumnToggleButton());
        MatcherAssert.assertThat((Object)this.grid.getVisibleColumns(), (Matcher)Matchers.hasSize((int)(nColumns + 1)));
        this.$server.setColumnToggleVisible(false);
        Assert.assertNull((String)"ColumnToggle should be absent", (Object)this.grid.getColumnToggleButton());
        MatcherAssert.assertThat((Object)this.grid.getVisibleColumns(), (Matcher)Matchers.hasSize((int)nColumns));
    }

    @Test
    public void testColumnToggleClick() {
        int nColumns = this.grid.getVisibleColumns().size();
        this.$server.setColumnToggleVisible(true);
        this.grid.getColumnToggleButton().click();
        MatcherAssert.assertThat(this.grid.getColumnToggleElements(), (Matcher)Matchers.hasSize((int)nColumns));
        MatcherAssert.assertThat((Object)this.grid.getVisibleColumns(), (Matcher)Matchers.hasSize((int)(++nColumns)));
        this.grid.getColumnToggleElements().get(0).setChecked(false);
        MatcherAssert.assertThat((Object)this.grid.getVisibleColumns(), (Matcher)Matchers.hasSize((int)(nColumns - 1)));
        this.grid.getColumnToggleElements().get(0).setChecked(true);
        MatcherAssert.assertThat((Object)this.grid.getVisibleColumns(), (Matcher)Matchers.hasSize((int)nColumns));
    }

    @Test
    public void testColumnToggleListener() {
        this.$server.setColumnToggleVisible(true);
        Assert.assertNull((Object)this.$server.getToggledColumn());
        this.grid.getColumnToggleButton().click();
        this.grid.getColumnToggleElements().get(0).setChecked(false);
        Assert.assertEquals((Object)0, (Object)this.$server.getToggledColumn());
        this.grid.getColumnToggleElements().get(1).setChecked(false);
        Assert.assertEquals((Object)1, (Object)this.$server.getToggledColumn());
        this.grid.getColumnToggleElements().get(0).setChecked(true);
        Assert.assertEquals((Object)0, (Object)this.$server.getToggledColumn());
    }

    @Test
    public void testColumnHidable() {
        int nColumns = this.grid.getVisibleColumns().size();
        this.$server.setColumnToggleVisible(true);
        this.$server.setHidable(0, true);
        this.grid.getColumnToggleButton().click();
        MatcherAssert.assertThat(this.grid.getColumnToggleElements(), (Matcher)Matchers.hasSize((int)nColumns));
        this.$server.setHidable(0, false);
        this.grid.getColumnToggleButton().click();
        MatcherAssert.assertThat(this.grid.getColumnToggleElements(), (Matcher)Matchers.hasSize((int)(nColumns - 1)));
    }

    @Test
    public void testHidingToggleCaption() {
        String caption = "caption";
        this.$server.setHidingToggleCaption(0, caption);
        this.$server.setColumnToggleVisible(true);
        this.grid.getColumnToggleButton().click();
        Assert.assertEquals((Object)caption, (Object)this.grid.getColumnToggleElements().get(0).getLabel());
    }

    @Test
    public void testCustomHidingToggleCaption() {
        String caption = "HidingToggleCaption";
        this.$server.setHidingToggleCaption(0, caption);
        this.$server.setColumnToggleVisible(true);
        this.grid.getColumnToggleButton().click();
        Assert.assertEquals((Object)caption, (Object)this.grid.getColumnToggleElements().get(0).getLabel());
    }
}

