/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.it.AbstractViewTest;
import com.flowingcode.vaadin.addons.gridhelpers.it.GridHelperElement;
import com.flowingcode.vaadin.addons.gridhelpers.it.IntegrationViewCallables;
import com.flowingcode.vaadin.testbench.rpc.HasRpcSupport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.testbench.GridElement;
import org.junit.Assert;
import org.junit.Test;

public class SelectionColumnIT
extends AbstractViewTest
implements HasRpcSupport {
    IntegrationViewCallables $server = (IntegrationViewCallables)this.createCallableProxy(IntegrationViewCallables.class);
    GridHelperElement grid;

    public SelectionColumnIT() {
        super("it");
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.grid = new GridHelperElement((GridElement)this.$(GridElement.class).waitForFirst());
    }

    @Test
    public void testSelectionColumnHidden() {
        this.$server.setSelectionMode(Grid.SelectionMode.MULTI);
        Assert.assertNotNull((String)"the first column does not have checkboxes", (Object)this.grid.getSelectionCheckbox(0));
        this.$server.setSelectionColumnHidden(true);
        Assert.assertNull((String)"the first column has checkboxes", (Object)this.grid.getSelectionCheckbox(0));
    }

    @Test
    public void testSelectionColumnFrozen() {
        this.$server.setSelectionMode(Grid.SelectionMode.MULTI);
        String getParentOffset = "function getParentOffset(el) {return el.offsetParent ? el.offsetParent.offsetLeft + getParentOffset(el.offsetParent) : 0;}; return getParentOffset(arguments[0]);";
        this.$server.setSelectionColumnFrozen(true);
        long offsetBefore = (Long)this.executeScript(getParentOffset, new Object[]{this.grid.getSelectionCheckbox(0)});
        this.grid.executeScript("this.shadowRoot.querySelector('#table').scrollBy(1000,0)", new Object[0]);
        long offsetAfter = (Long)this.executeScript(getParentOffset, new Object[]{this.grid.getSelectionCheckbox(0)});
        Assert.assertNotEquals((long)offsetBefore, (long)offsetAfter);
    }
}

