/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.flowingcode.vaadin.addons.gridhelpers.it.AbstractViewTest;
import com.flowingcode.vaadin.addons.gridhelpers.it.GridHelperElement;
import com.flowingcode.vaadin.addons.gridhelpers.it.IntegrationViewCallables;
import com.flowingcode.vaadin.testbench.rpc.HasRpcSupport;
import com.flowingcode.vaadin.testbench.rpc.JsonArrayList;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.testbench.GridElement;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SelectOnClickIT
extends AbstractViewTest
implements HasRpcSupport {
    IntegrationViewCallables $server = (IntegrationViewCallables)this.createCallableProxy(IntegrationViewCallables.class);
    GridHelperElement grid;

    public SelectOnClickIT() {
        super("it");
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.grid = new GridHelperElement((GridElement)this.$(GridElement.class).waitForFirst());
    }

    @SafeVarargs
    private static <T> Matcher<? super JsonArrayList<T>> equalToList(T ... items) {
        return Matchers.equalTo(Arrays.asList(items));
    }

    @Test
    public void testSelectOnClickMulti() {
        MatcherAssert.assertThat(this.$server.getSelectedRows(), (Matcher)Matchers.empty());
        this.$server.setSelectionMode(Grid.SelectionMode.MULTI);
        this.$server.setSelectOnClick(true);
        this.grid.getCell(0, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(0));
        this.grid.getCell(1, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(0, 1));
        this.grid.getCell(3, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(0, 1, 3));
    }

    @Test
    public void testSelectOnClickSingle() {
        MatcherAssert.assertThat(this.$server.getSelectedRows(), (Matcher)Matchers.empty());
        this.$server.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.$server.setSelectOnClick(true);
        this.grid.getCell(0, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(0));
        this.grid.getCell(1, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(1));
        this.grid.getCell(3, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), SelectOnClickIT.equalToList(3));
    }

    @Test
    public void testSelectOnClickNone() {
        MatcherAssert.assertThat(this.$server.getSelectedRows(), (Matcher)Matchers.empty());
        this.$server.setSelectionMode(Grid.SelectionMode.NONE);
        this.$server.setSelectOnClick(true);
        this.grid.getCell(0, 1).click();
        MatcherAssert.assertThat(this.$server.getSelectedRows(), (Matcher)Matchers.empty());
    }
}

