/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;

class SelectionFilterHelper<T>
implements Serializable {
    private final GridHelper<T> helper;
    private Registration selectionListenerRegistration;
    private SerializablePredicate<T> selectionFilter;

    public void setSelectionFilter(SerializablePredicate<T> predicate) {
        Optional.ofNullable(this.selectionListenerRegistration).ifPresent(Registration::remove);
        this.selectionListenerRegistration = null;
        Grid<T> grid = this.helper.getGrid();
        this.selectionFilter = predicate;
        if (predicate != null) {
            this.deselectIf(predicate.negate());
            this.helper.setHelperClassNameGenerator(this.getClass(), (SerializableFunction & Serializable)row -> predicate.test(row) ? null : "fcGh-noselect");
            this.selectionListenerRegistration = grid.addSelectionListener(this::onSelection);
        } else {
            this.helper.setHelperClassNameGenerator(this.getClass(), null);
        }
    }

    boolean canSelect(T item) {
        return this.selectionFilter == null || this.selectionFilter.test(item);
    }

    private void deselectIf(SerializablePredicate<T> predicate) {
        Grid grid = this.helper.getGrid();
        switch (GridHelper.getSelectionMode(grid)) {
            case MULTI: {
                grid.asMultiSelect().deselect((Iterable)grid.asMultiSelect().getSelectedItems().stream().filter(predicate).collect(Collectors.toList()));
                break;
            }
            case SINGLE: {
                grid.asSingleSelect().getOptionalValue().filter(predicate).ifPresent(x -> grid.asSingleSelect().clear());
                break;
            }
        }
    }

    private void onSelection(SelectionEvent<Grid<T>, T> event) {
        if (event.isFromClient()) {
            event.getAllSelectedItems().forEach(item -> {
                if (!this.canSelect(item)) {
                    ((Grid)event.getSource()).deselect(item);
                }
            });
        }
    }

    public SelectionFilterHelper(GridHelper<T> helper) {
        this.helper = helper;
    }

    public SerializablePredicate<T> getSelectionFilter() {
        return this.selectionFilter;
    }
}

