/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.Renderer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;

class HeaderFooterGridHelper
implements Serializable {
    private final GridHelper<?> helper;
    private static final Method getHeaderText = HeaderFooterGridHelper.getMethod(Grid.Column.class, "getHeaderText").orElse(null);
    private static final Method getFooterText = HeaderFooterGridHelper.getMethod(Grid.Column.class, "getFooterText").orElse(null);

    private static Optional<Method> getMethod(Class<?> clazz, String name) {
        try {
            return Optional.of(clazz.getMethod(name, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private static String getTemplate(Renderer<?> renderer) {
        try {
            Field templateField = Renderer.class.getDeclaredField("template");
            templateField.setAccessible(true);
            String template = (String)templateField.get(renderer);
            return template == null ? "" : template;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Renderer<?> getHeaderRenderer(Grid.Column<?> column) {
        try {
            Class<?> clazz = Class.forName("com.vaadin.flow.component.grid.AbstractColumn");
            Method m = clazz.getDeclaredMethod("getHeaderRenderer", new Class[0]);
            m.setAccessible(true);
            return (Renderer)m.invoke(column, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Renderer<?> getFooterRenderer(Grid.Column<?> column) {
        try {
            Class<?> clazz = Class.forName("com.vaadin.flow.component.grid.AbstractColumn");
            Method m = clazz.getDeclaredMethod("getFooterRenderer", new Class[0]);
            m.setAccessible(true);
            return (Renderer)m.invoke(column, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getHeader(Grid.Column<?> column) {
        if (getHeaderText != null) {
            try {
                return (String)getHeaderText.invoke(column, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Renderer<?> headerRenderer = HeaderFooterGridHelper.getHeaderRenderer(column);
        return HeaderFooterGridHelper.getTemplate(headerRenderer);
    }

    public String getFooter(Grid.Column<?> column) {
        if (getFooterText != null) {
            try {
                return (String)getFooterText.invoke(column, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Renderer<?> headerRenderer = HeaderFooterGridHelper.getFooterRenderer(column);
        return headerRenderer == null ? null : HeaderFooterGridHelper.getTemplate(headerRenderer);
    }

    public HeaderFooterGridHelper(GridHelper<?> helper) {
        this.helper = helper;
    }
}

