/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.Renderer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.validation.constraints.NotNull;

class HeaderFooterGridHelper
implements Serializable {
    private final GridHelper<?> helper;

    @NotNull
    private static String getTemplate(@NotNull Renderer<?> renderer) {
        try {
            Field templateField = Renderer.class.getDeclaredField("template");
            templateField.setAccessible(true);
            String template = (String)templateField.get(renderer);
            return template == null ? "" : template;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static Renderer<?> getHeaderRenderer(@NotNull Grid.Column<?> column) {
        try {
            Class<?> clazz = Class.forName("com.vaadin.flow.component.grid.AbstractColumn");
            Method m = clazz.getDeclaredMethod("getHeaderRenderer", new Class[0]);
            m.setAccessible(true);
            return (Renderer)m.invoke(column, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static Renderer<?> getFooterRenderer(@NotNull Grid.Column<?> column) {
        try {
            Class<?> clazz = Class.forName("com.vaadin.flow.component.grid.AbstractColumn");
            Method m = clazz.getDeclaredMethod("getFooterRenderer", new Class[0]);
            m.setAccessible(true);
            return (Renderer)m.invoke(column, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    public String getHeader(@NotNull Grid.Column<?> column) {
        Renderer<?> headerRenderer = HeaderFooterGridHelper.getHeaderRenderer(column);
        return HeaderFooterGridHelper.getTemplate(headerRenderer);
    }

    public String getFooter(@NotNull Grid.Column<?> column) {
        Renderer<?> headerRenderer = HeaderFooterGridHelper.getFooterRenderer(column);
        return headerRenderer == null ? null : HeaderFooterGridHelper.getTemplate(headerRenderer);
    }

    public HeaderFooterGridHelper(GridHelper<?> helper) {
        this.helper = helper;
    }
}

