/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers.it;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.ScreenshotOnFailureRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.ParallelTest;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

public abstract class AbstractViewTest
extends ParallelTest {
    private static final int SERVER_PORT = 8080;
    private final String route;
    @Rule
    public ScreenshotOnFailureRule rule = new ScreenshotOnFailureRule((HasDriver)this, true);
    private static final String USE_HUB_PROPERTY = "test.use.hub";

    public AbstractViewTest() {
        this("");
    }

    protected AbstractViewTest(String route) {
        this.route = route;
    }

    @BeforeClass
    public static void setupClass() {
        WebDriverManager.chromedriver().setup();
    }

    @Before
    public void setup() throws Exception {
        if (AbstractViewTest.isUsingHub()) {
            super.setup();
        } else {
            this.setDriver((WebDriver)TestBench.createDriver((WebDriver)new ChromeDriver()));
        }
        this.getDriver().get(AbstractViewTest.getURL(this.route));
    }

    private static String getURL(String route) {
        return String.format("http://%s:%d/%s", AbstractViewTest.getDeploymentHostname(), 8080, route);
    }

    private static boolean isUsingHub() {
        return Boolean.TRUE.toString().equals(System.getProperty(USE_HUB_PROPERTY));
    }

    private static String getDeploymentHostname() {
        return AbstractViewTest.isUsingHub() ? System.getenv("HOSTNAME") : "localhost";
    }
}

