/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@PageTitle(value="All Features")
@GithubLink(value="https://github.com/FlowingCode/GridHelpers")
@StyleSheet(value="context://gridhelpers/styles.css")
public class AllFeaturesDemo
extends Div {
    private final Map<Checkbox, List<Grid.SelectionMode>> checkboxes = new HashMap<Checkbox, List<Grid.SelectionMode>>();

    public AllFeaturesDemo() {
        this.setSizeFull();
        this.getElement().getStyle().set("flex-grow", "1");
        Grid grid = new Grid();
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getLastName).setHeader("Last name"), (String)"Last name column");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getFirstName).setHeader("First name"), (String)"First name column");
        GridHelper.setHidable((Grid.Column)grid.addColumn((ValueProvider & Serializable)p -> p.isActive() ? "Yes" : "No").setHeader("Active"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getTitle).setHeader("Title"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getCountry).setHeader("Country"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getCity).setHeader("City"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getStreetAddress).setHeader("Street Address"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getPhoneNumber).setHeader("Phone Number"), (boolean)true);
        GridHelper.setHidable((Grid.Column)grid.addColumn(Person::getEmailAddress).setHeader("Email Address"), (boolean)true);
        grid.getColumns().forEach(c -> c.setAutoWidth(true));
        grid.setItems(TestData.initializeData());
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.getElement().getStyle().set("flex-grow", "1");
        VerticalLayout features = new VerticalLayout();
        features.getStyle().set("margin-left", "4px");
        features.getStyle().set("margin-right", "-4px");
        features.getStyle().set("min-width", "310px");
        features.setPadding(false);
        features.setWidth(null);
        VerticalLayout layout = new VerticalLayout(new Component[]{grid});
        layout.setPadding(false);
        SplitLayout split = new SplitLayout((Component)layout, (Component)features);
        split.setSplitterPosition(100.0);
        split.setHeightFull();
        this.add(new Component[]{split});
        GridHelper.setSelectOnClick((Grid)grid, (boolean)true);
        GridHelper.setColumnToggleVisible((Grid)grid, (boolean)true);
        GridHelper.addColumnToggleListener((Grid)grid, (ComponentEventListener & Serializable)ev -> {
            String caption = GridHelper.getHidingToggleCaption((Grid.Column)ev.getColumn());
            String message = caption + " is now " + (ev.getColumn().isVisible() ? "visible" : "invisible");
            new Notification(message).open();
        });
        Binder binder = new Binder();
        binder.setBean((Object)grid);
        Select select = new Select((Object[])Grid.SelectionMode.values());
        select.setLabel("Selection mode");
        binder.forField((HasValue)select).bind(GridHelper::getSelectionMode, this::setSelectionMode);
        binder.forField((HasValue)this.newCheckbox("Hide selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnHidden, GridHelper::setSelectionColumnHidden);
        binder.forField((HasValue)this.newCheckbox("Freeze selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnFrozen, GridHelper::setSelectionColumnFrozen);
        binder.forField((HasValue)this.newCheckbox("Arrow selection enabled", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(GridHelper::isArrowSelectionEnabled, GridHelper::setArrowSelectionEnabled);
        binder.forField((HasValue)this.newCheckbox("Enable selection by clicking row", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectOnClick, GridHelper::setSelectOnClick);
        binder.forField((HasValue)this.newCheckbox("Disallow selection of 'inactive' records", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(this::hasSelectionFilter, this::setSelectionFilter);
        binder.forField((HasValue)new Checkbox("Dense Theme")).bind(this::hasDenseTheme, this::setDenseTheme);
        binder.getFields().map(Component.class::cast).forEach(xva$0 -> features.add(new Component[]{xva$0}));
        Label label = new Label("Features");
        label.addClassNames(new String[]{"label"});
        features.addComponentAtIndex(1, (Component)label);
        this.setSelectionMode((Grid<Person>)grid, GridHelper.getSelectionMode((Grid)grid));
        HorizontalLayout hl = new HorizontalLayout();
        hl.setPadding(false);
        Div toolbarFooterLabel = new Div(new Component[]{new Text("Toolbar Footer")});
        toolbarFooterLabel.getStyle().set("margin", "auto");
        hl.setSizeFull();
        Button toolbarFooterButton = new Button((Component)VaadinIcon.TOOLS.create(), (ComponentEventListener & Serializable)ev -> Notification.show((String)"You clicked a button in the Toolbar Footer"));
        toolbarFooterButton.getThemeNames().add((Object)"small");
        hl.add(new Component[]{toolbarFooterLabel, toolbarFooterButton});
        hl.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        GridHelper.addToolbarFooter((Grid)grid, (Component)hl);
    }

    private Checkbox newCheckbox(String labelText, Grid.SelectionMode ... modes) {
        Checkbox checkbox = new Checkbox(labelText);
        if (modes.length > 0) {
            this.checkboxes.put(checkbox, Arrays.asList(modes));
        }
        return checkbox;
    }

    private void setSelectionMode(Grid<Person> grid, Grid.SelectionMode selectionMode) {
        grid.setSelectionMode(selectionMode);
        GridHelper.setSelectionFilter(grid, (SerializablePredicate)GridHelper.getSelectionFilter(grid));
        this.checkboxes.forEach((checkbox, modes) -> {
            if (modes.contains(selectionMode)) {
                checkbox.getElement().removeAttribute("title");
            } else if (modes.size() == 1) {
                checkbox.getElement().setAttribute("title", String.format("This feature only has effect in %s selection mode", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase()));
            } else if (modes.size() == 2) {
                checkbox.getElement().setAttribute("title", String.format("This feature only has effect in %s and %s selection modes", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase(), ((Grid.SelectionMode)modes.get(1)).toString().toLowerCase()));
            }
        });
        if (selectionMode == Grid.SelectionMode.MULTI) {
            grid.getStyle().remove("--fcgh-noselect-opacity");
        } else {
            grid.getStyle().set("--fcgh-noselect-opacity", "1");
        }
    }

    private void setSelectionFilter(Grid<Person> grid, boolean value) {
        if (value) {
            GridHelper.setSelectionFilter(grid, Person::isActive);
        } else {
            GridHelper.setSelectionFilter(grid, null);
        }
    }

    private boolean hasSelectionFilter(Grid<Person> grid) {
        return GridHelper.getSelectionFilter(grid) != null;
    }

    private void setDenseTheme(Grid<Person> grid, boolean value) {
        if (value) {
            grid.addThemeName("fcGh-dense");
        } else {
            grid.removeThemeName("fcGh-dense");
        }
    }

    private boolean hasDenseTheme(Grid<Person> grid) {
        return grid.hasThemeName("fcGh-dense");
    }
}

