/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;

class ColumnToggleHelper
implements Serializable {
    private static final String GRID_HELPER_TOGGLE_THEME = "gridHelperToggle";
    private static final String TOGGLE_LABEL_DATA = GridHelper.class.getName() + "#TOGGLE_LABEL";
    private final GridHelper<?> helper;
    private Grid.Column<?> menuToggleColumn;

    public void setColumnToggleVisible(boolean visible) {
        if (visible) {
            this.showColumnToggle();
        } else {
            this.hideColumnToggle();
        }
    }

    public boolean isColumnToggleVisible() {
        return this.menuToggleColumn != null && this.menuToggleColumn.isVisible();
    }

    private void showColumnToggle() {
        this.createMenuToggle().ifPresent(toggle -> {
            Grid<?> grid = this.helper.getGrid();
            if (this.menuToggleColumn == null) {
                this.menuToggleColumn = grid.addColumn((ValueProvider & Serializable)t -> "").setWidth("auto").setFlexGrow(0);
            } else {
                this.menuToggleColumn.setVisible(true);
            }
            ((HeaderRow.HeaderCell)((HeaderRow)grid.getHeaderRows().get(0)).getCell(this.menuToggleColumn)).setComponent((Component)toggle);
        });
    }

    private void hideColumnToggle() {
        if (this.menuToggleColumn != null) {
            this.menuToggleColumn.setVisible(false);
        }
    }

    private Optional<MenuBar> createMenuToggle() {
        Grid<?> grid = this.helper.getGrid();
        MenuBar menuBar = new MenuBar();
        menuBar.addThemeVariants(new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY_INLINE});
        MenuItem menuItem = menuBar.addItem((Component)VaadinIcon.ELLIPSIS_DOTS_V.create());
        SubMenu subMenu = (SubMenu)menuItem.getSubMenu();
        for (Grid.Column column : grid.getColumns()) {
            this.getToggleLabel(column).ifPresent(label -> {
                Checkbox checkbox = new Checkbox(label);
                checkbox.setValue((Object)column.isVisible());
                checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> column.setVisible(((Boolean)e.getValue()).booleanValue()));
                subMenu.addItem((Component)checkbox);
            });
        }
        menuBar.getThemeNames().add((Object)GRID_HELPER_TOGGLE_THEME);
        return Optional.of(menuBar).filter(_menuBar -> !_menuBar.getItems().isEmpty());
    }

    private Optional<String> getToggleLabel(@NonNull Grid.Column<?> column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return Optional.ofNullable((String)ComponentUtil.getData(column, (String)TOGGLE_LABEL_DATA));
    }

    public void setHidingToggleCaption(Grid.Column<?> column, String caption) {
        if (column != null) {
            Grid<?> grid = this.helper.getGrid();
            if (!grid.getColumns().contains(column)) {
                throw new IllegalArgumentException();
            }
            ComponentUtil.setData(column, (String)TOGGLE_LABEL_DATA, (Object)caption);
            if (this.isColumnToggleVisible()) {
                this.showColumnToggle();
            }
        }
    }

    Grid.Column<?> getMenuToggleColumn() {
        return this.menuToggleColumn;
    }

    public ColumnToggleHelper(GridHelper<?> helper) {
        this.helper = helper;
    }
}

