/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import java.io.Serializable;

@PageTitle(value="Using Lombok")
@DemoSource(value="https://github.com/FlowingCode/GridHelpers/blob/master/src/test/java/com/flowingcode/vaadin/addons/gridhelpers/LombokDemo.java")
public class LombokDemo
extends Div {
    public LombokDemo() {
        this.setSizeFull();
        Grid grid = new Grid();
        grid.setItems(TestData.initializeData());
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getFirstName).setHeader("First name"), (String)"First name");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getLastName).setHeader("Last name"), (String)"Last name");
        grid.addColumn((ValueProvider & Serializable)p -> p.isActive() ? "Yes" : "No").setHeader("Active");
        grid.addColumn(Person::getTitle).setHeader("Title");
        grid.addColumn(Person::getCountry).setHeader("Country");
        grid.addColumn(Person::getCity).setHeader("City");
        grid.addColumn(Person::getStreetAddress).setHeader("Street Address");
        grid.getColumns().forEach(c -> c.setAutoWidth(true));
        GridHelper.setColumnToggleVisible((Grid)grid, (boolean)true);
        GridHelper.setSelectionColumnFrozen((Grid)grid, (boolean)true);
        GridHelper.setSelectOnClick((Grid)grid, (boolean)true);
        GridHelper.setSelectionFilter((Grid)grid, Person::isActive);
        grid.setHeightFull();
        this.add(new Component[]{grid});
    }
}

