/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.Person;
import com.flowingcode.vaadin.addons.gridhelpers.TestData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@PageTitle(value="All Features")
@GithubLink(value="https://github.com/FlowingCode/GridHelpers")
@StyleSheet(value="context://gridhelpers/styles.css")
public class AllFeaturesDemo
extends Div {
    private final Map<Checkbox, List<Grid.SelectionMode>> checkboxes = new HashMap<Checkbox, List<Grid.SelectionMode>>();

    public AllFeaturesDemo() {
        this.setSizeFull();
        Grid grid = new Grid();
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getLastName).setHeader("Last name"), (String)"Last name");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getFirstName).setHeader("First name"), (String)"First name");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn((ValueProvider & Serializable)p -> p.isActive() ? "Yes" : "No").setHeader("Active"), (String)"Active");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getTitle).setHeader("Title"), (String)"Title");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getCountry).setHeader("Country"), (String)"Country");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getCity).setHeader("City"), (String)"City");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getStreetAddress).setHeader("Street Address"), (String)"Street Address");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getPhoneNumber).setHeader("Phone Number"), (String)"Phone Number");
        GridHelper.setHidingToggleCaption((Grid.Column)grid.addColumn(Person::getEmailAddress).setHeader("Email Address"), (String)"Email Address");
        grid.getColumns().forEach(c -> c.setAutoWidth(true));
        grid.setItems(TestData.initializeData());
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.getElement().getStyle().set("flex-grow", "1");
        grid.setHeight("100vh");
        VerticalLayout features = new VerticalLayout();
        features.getStyle().set("margin-left", "4px");
        features.getStyle().set("margin-right", "-4px");
        features.getStyle().set("min-width", "310px");
        features.setPadding(false);
        features.setWidth(null);
        SplitLayout split = new SplitLayout((Component)grid, (Component)features);
        split.setSplitterPosition(100.0);
        this.add(new Component[]{split});
        GridHelper.setSelectOnClick((Grid)grid, (boolean)true);
        GridHelper.setColumnToggleVisible((Grid)grid, (boolean)true);
        Binder binder = new Binder();
        binder.setBean((Object)grid);
        Select select = new Select((Object[])Grid.SelectionMode.values());
        select.setLabel("Selection mode");
        binder.forField((HasValue)select).bind(GridHelper::getSelectionMode, this::setSelectionMode);
        binder.forField((HasValue)this.newCheckbox("Hide selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnHidden, GridHelper::setSelectionColumnHidden);
        binder.forField((HasValue)this.newCheckbox("Freeze selection column", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectionColumnFrozen, GridHelper::setSelectionColumnFrozen);
        binder.forField((HasValue)this.newCheckbox("Arrow selection enabled", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(GridHelper::isArrowSelectionEnabled, GridHelper::setArrowSelectionEnabled);
        binder.forField((HasValue)this.newCheckbox("Enable selection by clicking row", Grid.SelectionMode.MULTI)).bind(GridHelper::isSelectOnClick, GridHelper::setSelectOnClick);
        binder.forField((HasValue)this.newCheckbox("Disallow selection of 'inactive' records", Grid.SelectionMode.SINGLE, Grid.SelectionMode.MULTI)).bind(this::hasSelectionFilter, this::setSelectionFilter);
        binder.forField((HasValue)new Checkbox("Dense Theme")).bind(this::hasDenseTheme, this::setDenseTheme);
        binder.getFields().map(Component.class::cast).forEach(xva$0 -> features.add(new Component[]{xva$0}));
        Label label = new Label("Features");
        label.addClassNames(new String[]{"label"});
        features.addComponentAtIndex(1, (Component)label);
    }

    private Checkbox newCheckbox(String labelText, Grid.SelectionMode ... modes) {
        Checkbox checkbox = new Checkbox(labelText);
        if (modes.length > 0) {
            this.checkboxes.put(checkbox, Arrays.asList(modes));
        }
        return checkbox;
    }

    private void setSelectionMode(Grid<Person> grid, Grid.SelectionMode selectionMode) {
        grid.setSelectionMode(selectionMode);
        this.checkboxes.forEach((checkbox, modes) -> {
            if (modes.contains(selectionMode)) {
                checkbox.getElement().removeAttribute("title");
            } else if (modes.size() == 1) {
                checkbox.getElement().setAttribute("title", String.format("This feature only have effect in %s selection mode", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase()));
            } else if (modes.size() == 2) {
                checkbox.getElement().setAttribute("title", String.format("This feature only have effect in %s and %s selection modes", ((Grid.SelectionMode)modes.get(0)).toString().toLowerCase(), ((Grid.SelectionMode)modes.get(1)).toString().toLowerCase()));
            }
        });
    }

    private void setSelectionFilter(Grid<Person> grid, boolean value) {
        if (value) {
            GridHelper.setSelectionFilter(grid, Person::isActive);
        } else {
            GridHelper.setSelectionFilter(grid, null);
        }
    }

    private boolean hasSelectionFilter(Grid<Person> grid) {
        return GridHelper.getSelectionFilter(grid) != null;
    }

    private void setDenseTheme(Grid<Person> grid, boolean value) {
        if (value) {
            grid.addThemeName("fcGh-dense");
        } else {
            grid.removeThemeName("fcGh-dense");
        }
    }

    private boolean hasDenseTheme(Grid<Person> grid) {
        return grid.hasThemeName("fcGh-dense");
    }
}

