/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.stream.Collectors;

class SelectionFilterHelper<T>
implements Serializable {
    private final GridHelper<T> helper;
    private SerializablePredicate<T> selectionFilter;

    public void setSelectionFilter(SerializablePredicate<T> predicate) {
        this.selectionFilter = predicate;
        if (predicate != null) {
            this.deselectIf(predicate.negate());
        }
    }

    boolean canSelect(T item) {
        return this.selectionFilter == null || this.selectionFilter.test(item);
    }

    private void deselectIf(SerializablePredicate<T> predicate) {
        Grid grid = this.helper.getGrid();
        switch (GridHelper.getSelectionMode(grid)) {
            case MULTI: {
                grid.asMultiSelect().deselect((Iterable)grid.asMultiSelect().getSelectedItems().stream().filter(predicate).collect(Collectors.toList()));
                break;
            }
            case SINGLE: {
                grid.asSingleSelect().getOptionalValue().filter(predicate).ifPresent(x -> grid.asSingleSelect().clear());
                break;
            }
        }
    }

    public SelectionFilterHelper(GridHelper<T> helper) {
        this.helper = helper;
    }

    public SerializablePredicate<T> getSelectionFilter() {
        return this.selectionFilter;
    }
}

