/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.vaadin.flow.function.SerializableFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

final class GridHelperClassNameGenerator<T>
implements SerializableFunction<T, String> {
    private Map<String, SerializableFunction<T, String>> helperClassNameGenerators = new HashMap<String, SerializableFunction<T, String>>();
    private SerializableFunction<T, String> gridClassNameGenerator;
    private transient boolean invoked;

    GridHelperClassNameGenerator() {
    }

    void removeHelperClassNameGenerator(String name) {
        this.helperClassNameGenerators.remove(name);
    }

    void setHelperClassNameGenerator(String name, SerializableFunction<T, String> generator) {
        this.helperClassNameGenerators.put(name, generator);
    }

    private Stream<SerializableFunction<T, String>> generators() {
        return Stream.concat(Optional.ofNullable(this.gridClassNameGenerator).map(Stream::of).orElseGet(Stream::empty), this.helperClassNameGenerators.values().stream());
    }

    public String apply(T t) {
        if (this.invoked) {
            return null;
        }
        this.invoked = true;
        try {
            String string = StringUtils.trimToNull((String)this.generators().map(generator -> (String)generator.apply(t)).map(StringUtils::trimToNull).filter(Objects::nonNull).flatMap(s -> Stream.of(s.trim().split("\\s+"))).distinct().collect(Collectors.joining(" ")));
            return string;
        }
        finally {
            this.invoked = false;
        }
    }

    public SerializableFunction<T, String> getGridClassNameGenerator() {
        return this.gridClassNameGenerator;
    }

    public void setGridClassNameGenerator(SerializableFunction<T, String> gridClassNameGenerator) {
        this.gridClassNameGenerator = gridClassNameGenerator;
    }
}

