/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.ColumnToggleHelper;
import com.flowingcode.vaadin.addons.gridhelpers.EmptyLabelGridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelperClassNameGenerator;
import com.flowingcode.vaadin.addons.gridhelpers.SelectionColumnHelper;
import com.flowingcode.vaadin.addons.gridhelpers.SelectionFilterHelper;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;

@JsModule(value="./fcGridHelper/connector.js")
@CssImport.Container(value={@CssImport(value="./fcGridHelper/vaadin-menu-bar.css", themeFor="vaadin-menu-bar"), @CssImport(value="./fcGridHelper/vaadin-grid.css", themeFor="vaadin-grid")})
public final class GridHelper<T>
implements Serializable {
    private static final String ARROW_SELECTION_PROPERTY = "_fcghArrowSelection";
    public static final String GRID_STYLES = "./fcGridHelper/vaadin-grid.css";
    public static final String DENSE_THEME = "fcGh-dense";
    private final Grid<T> grid;
    private final GridHelperClassNameGenerator<T> helperClassNameGenerator;
    private boolean selectOnClick;
    private final SelectionColumnHelper selectionColumnHelper = new SelectionColumnHelper(this);
    private final SelectionFilterHelper<T> selectionFilterHelper = new SelectionFilterHelper(this);
    private final ColumnToggleHelper columnToggleHelper = new ColumnToggleHelper(this);
    private final EmptyLabelGridHelper emptyLabel = new EmptyLabelGridHelper(this);

    private GridHelper(Grid<T> grid) {
        this.grid = grid;
        this.helperClassNameGenerator = new GridHelperClassNameGenerator();
        grid.addItemClickListener(this::onItemClick);
        grid.addAttachListener(this::onAttach);
    }

    private static <T> GridHelper<T> getHelper(Grid.Column<T> column) {
        return GridHelper.getHelper(column.getGrid());
    }

    private static <T> GridHelper<T> getHelper(Grid<T> grid) {
        GridHelper<T> helper = (GridHelper<T>)ComponentUtil.getData(grid, GridHelper.class);
        if (helper == null) {
            helper = new GridHelper<T>(grid);
            ComponentUtil.setData(grid, GridHelper.class, helper);
        }
        return helper;
    }

    private void initConnector() {
        ((UI)this.grid.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached Grid"))).getPage().executeJs("window.Vaadin.Flow.fcGridHelperConnector.initLazy($0)", new Serializable[]{this.grid.getElement()});
    }

    private void onAttach(AttachEvent event) {
        this.initConnector();
        this.selectionColumnHelper.onAttach();
    }

    private void onItemClick(ItemClickEvent<T> event) {
        Object item = event.getItem();
        if (this.selectOnClick) {
            if (!this.selectionFilterHelper.canSelect(item)) {
                return;
            }
            if (this.grid.getSelectedItems().contains(item)) {
                this.grid.deselect(item);
            } else {
                this.grid.select(item);
            }
        }
    }

    public static Grid.SelectionMode getSelectionMode(Grid<?> grid) {
        GridSelectionModel model = grid.getSelectionModel();
        if (model instanceof GridSingleSelectionModel) {
            return Grid.SelectionMode.SINGLE;
        }
        if (model instanceof GridMultiSelectionModel) {
            return Grid.SelectionMode.MULTI;
        }
        return Grid.SelectionMode.NONE;
    }

    public void setClassNameGenerator(SerializableFunction<T, String> classNameGenerator) {
        this.grid.setClassNameGenerator(this.helperClassNameGenerator);
        if (classNameGenerator instanceof GridHelperClassNameGenerator) {
            this.helperClassNameGenerator.setGridClassNameGenerator(((GridHelperClassNameGenerator)classNameGenerator).getGridClassNameGenerator());
        } else {
            this.helperClassNameGenerator.setGridClassNameGenerator(classNameGenerator);
        }
    }

    public static void setSelectOnClick(Grid<?> grid, boolean selectOnClick) {
        GridHelper.getHelper(grid).selectOnClick = selectOnClick;
    }

    public static boolean isSelectOnClick(Grid<?> grid) {
        return GridHelper.getHelper(grid).selectOnClick;
    }

    public static void setArrowSelectionEnabled(Grid<?> grid, boolean value) {
        grid.getElement().setProperty(ARROW_SELECTION_PROPERTY, value);
    }

    public static boolean isArrowSelectionEnabled(Grid<?> grid) {
        return grid.getElement().getProperty(ARROW_SELECTION_PROPERTY, false);
    }

    public static void setSelectionColumnHidden(Grid<?> grid, boolean value) {
        GridHelper.getHelper(grid).selectionColumnHelper.setSelectionColumnHidden(value);
    }

    public static void setSelectionColumnFrozen(Grid<?> grid, boolean value) {
        GridHelper.getHelper(grid).selectionColumnHelper.setSelectionColumnFrozen(value);
    }

    public static boolean isSelectionColumnHidden(Grid<?> grid) {
        return GridHelper.getHelper(grid).selectionColumnHelper.isSelectionColumnHidden();
    }

    public static boolean isSelectionColumnFrozen(Grid<?> grid) {
        return GridHelper.getHelper(grid).selectionColumnHelper.isSelectionColumnFrozen();
    }

    public static <T> void setSelectionFilter(Grid<T> grid, SerializablePredicate<T> predicate) {
        GridHelper.getHelper(grid).selectionFilterHelper.setSelectionFilter(predicate);
    }

    public static <T> SerializablePredicate<T> getSelectionFilter(Grid<T> grid) {
        return GridHelper.getHelper(grid).selectionFilterHelper.getSelectionFilter();
    }

    public static void setColumnToggleVisible(Grid<?> grid, boolean visible) {
        GridHelper.getHelper(grid).columnToggleHelper.setColumnToggleVisible(visible);
    }

    public static boolean isColumnToggleVisible(Grid<?> grid) {
        return GridHelper.getHelper(grid).columnToggleHelper.isColumnToggleVisible();
    }

    public static <T> void setHidingToggleCaption(Grid.Column<T> column, String caption) {
        GridHelper.getHelper(column.getGrid()).columnToggleHelper.setHidingToggleCaption(column, caption);
    }

    public static boolean isMenuToggleColumn(Grid.Column<?> column) {
        return column == GridHelper.getHelper(column).columnToggleHelper.getMenuToggleColumn();
    }

    public static void setEmptyGridLabel(Grid<?> grid, Component component) {
        GridHelper.getHelper(grid).emptyLabel.setEmptyGridLabel(component);
    }

    public static Component getEmptyGridLabel(Grid<?> grid) {
        return GridHelper.getHelper(grid).emptyLabel.getEmptyGridLabel();
    }

    Grid<T> getGrid() {
        return this.grid;
    }
}

