/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridFooter;
import com.flowingcode.vaadin.addons.gridexporter.GridHeader;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.StreamResourceWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseStreamResourceWriter<T>
implements StreamResourceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStreamResourceWriter.class);
    protected final GridExporter<T> exporter;
    private String template;

    public BaseStreamResourceWriter(GridExporter<T> exporter) {
        this.exporter = exporter;
    }

    public BaseStreamResourceWriter(GridExporter<T> exporter, String customTemplate, String defaultTemplate) {
        this.exporter = exporter;
        this.template = customTemplate == null ? defaultTemplate : customTemplate;
    }

    protected String getTemplate() {
        return this.template;
    }

    protected boolean isExportable(Grid.Column<T> column) {
        Boolean exported = (Boolean)ComponentUtil.getData(column, (String)"column-value-exported-data");
        return exported != null ? exported.booleanValue() : column.isVisible();
    }

    protected Stream<T> getDataStream(Query newQuery) {
        Stream stream = this.exporter.getGrid().getDataProvider().fetch(newQuery);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.exporter.getGrid().getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        return stream;
    }

    protected List<GridHeader<T>> getGridHeaders(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> this.getGridHeader(grid, (Grid.Column<T>)column)).collect(Collectors.toList());
    }

    private GridHeader<T> getGridHeader(Grid<T> grid, Grid.Column<T> column) {
        ArrayList<String> headerTexts = new ArrayList<String>();
        List headerRows = grid.getHeaderRows();
        for (HeaderRow headerRow : headerRows) {
            String headerText = this.renderHeaderCellTextContent(grid, headerRow, column);
            headerTexts.add(headerText);
        }
        return new GridHeader<T>(headerTexts, column);
    }

    protected List<GridFooter<T>> getGridFooters(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> new GridFooter(this.renderFooterCellTextContent(grid, (Grid.Column<T>)column), column)).collect(Collectors.toList());
    }

    private String obtainCellFunction(HeaderRow.HeaderCell headerCell, Grid.Column<T> column) {
        Component component;
        String value = headerCell.getText();
        if (Strings.isBlank((String)value) && (component = headerCell.getComponent()) != null) {
            value = component.getElement().getTextRecursively();
        }
        return value;
    }

    private String renderHeaderCellTextContent(Grid<T> grid, HeaderRow headerRow, Grid.Column<T> column) {
        String header = (String)ComponentUtil.getData(column, (String)"column-header");
        if (Strings.isBlank((String)header)) {
            HeaderRow.HeaderCell headerCell = (HeaderRow.HeaderCell)headerRow.getCell(column);
            int columnIndex = grid.getColumns().indexOf(column);
            if (columnIndex == 0 || headerRow.getCell((Grid.Column)grid.getColumns().get(columnIndex - 1)) != headerCell) {
                try {
                    header = this.obtainCellFunction(headerCell, column);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Problem when trying to render header cell text content", e);
                }
            }
        }
        return header == null ? "" : header;
    }

    private String renderFooterCellTextContent(Grid<T> grid, Grid.Column<T> column) {
        String footer = (String)ComponentUtil.getData(column, (String)"column-footer");
        if (Strings.isBlank((String)footer)) {
            SerializableFunction & Serializable footerComponent = (SerializableFunction & Serializable)rec$ -> ((Grid.Column)rec$).getFooterComponent();
            footer = column.getFooterText();
            if (Strings.isBlank((String)footer)) {
                try {
                    Component component = (Component)footerComponent.apply(column);
                    if (component != null) {
                        footer = component.getElement().getTextRecursively();
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Problem when trying to render footer cell text content", e);
                }
            }
        }
        return footer == null ? "" : footer;
    }

    protected Stream<T> obtainDataStream(DataProvider<T, ?> dataProvider) {
        Stream<T> dataStream;
        Grid<T> grid = this.exporter.getGrid();
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        if (grid.getDataProvider() instanceof HierarchicalDataProvider) {
            return this.obtainFlattenedHierarchicalDataStream(grid);
        }
        if (dataProvider instanceof AbstractBackEndDataProvider) {
            GridLazyDataView gridLazyDataView = grid.getLazyDataView();
            dataStream = gridLazyDataView.getItems();
        } else {
            Query streamQuery = new Query(0, grid.getDataProvider().size(new Query(filter)), grid.getDataCommunicator().getBackEndSorting(), (Comparator)grid.getDataCommunicator().getInMemorySorting(), filter);
            dataStream = this.getDataStream(streamQuery);
        }
        return dataStream;
    }

    private Stream<T> obtainFlattenedHierarchicalDataStream(Grid<T> grid) {
        ArrayList<Object> flattenedData = this.fetchDataRecursive(grid, null);
        return flattenedData.stream();
    }

    private ArrayList<T> fetchDataRecursive(Grid<T> grid, T parent) {
        HierarchicalDataProvider hDataProvider;
        int childCount;
        ArrayList<T> result = new ArrayList<T>();
        if (parent != null) {
            result.add(parent);
        }
        if ((childCount = (hDataProvider = (HierarchicalDataProvider)grid.getDataProvider()).getChildCount(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent))) > 0) {
            hDataProvider.fetchChildren(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent)).forEach(child -> {
                ArrayList<Object> subTree = this.fetchDataRecursive(grid, child);
                result.addAll(subTree);
            });
        }
        return result;
    }
}

