/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.DemoSources;
import com.flowingcode.vaadin.addons.demo.SourceCodeViewer;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.flowingcode.vaadin.addons.gridexporter.VaadinServiceInitListenerImpl;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.HeightMode;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.EncryptedDocumentException;

@DemoSources(value={@DemoSource, @DemoSource(clazz=VaadinServiceInitListenerImpl.class)})
@PageTitle(value="Big Dataset")
@Route(value="gridexporter/bigdataset", layout=GridExporterDemoView.class)
public class GridExporterBigDatasetDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterBigDatasetDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.setColumnReorderingAllowed(true);
        Grid.Column nameCol = grid.addColumn("name").setHeader("Name");
        Grid.Column lastNameCol = grid.addColumn("lastName").setHeader("Last Name");
        Grid.Column budgetCol = grid.addColumn((ValueProvider & Serializable)item -> "$" + item.getBudget()).setHeader("Budget");
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        List persons = IntStream.range(0, 1400).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            budgetCol.setFooter("$" + total[0]);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget);
        }).collect(Collectors.toList());
        grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> persons.stream().skip(query.getOffset()).limit(query.getLimit()));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid);
        exporter.setAutoSizeColumns(false);
        exporter.setExportValue(budgetCol, (ValueProvider & Serializable)item -> "" + item.getBudget());
        exporter.setColumnPosition(lastNameCol, 1);
        exporter.setTitle("People information");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        GridHelper.setHeightByRows((Grid)grid, (int)6);
        GridHelper.setHeightMode((Grid)grid, (HeightMode)HeightMode.ROW);
        Html block1 = new Html("<div>\nThis configuration prepares the exporter for the BigDataset demo, enabling it to manage resource-intensive\ndocument generation tasks effectively. In this setup, an upper limit of 10 is established for the cost of\nconcurrent downloads, and the big dataset exporter is configured with a cost of 9, while other exporters\nhandling smaller datasets retain the default cost of 1. This customization allows a combination of one large\ndataset download alongside one small dataset download, or up to 10 concurrent downloads of smaller datasets\nwhen no big dataset is being exported.\n</div>");
        Html block2 = new Html("<div>\nAdditionally, <code>setConcurrentDownloadTimeout</code> enforces a timeout for acquiring the necessary permits\nduring a download operation. If the permits are not obtained within the specified timeframe, the download\nrequest will be aborted and the <code>DownloadTimeoutEvent</code> listener will execute, preventing prolonged\nwaiting periods, especially during peak system loads.\n</div>");
        this.add(new Component[]{block1, grid, block2});
        SourceCodeViewer.highlightOnHover((Component)block1, (String)"concurrent");
        SourceCodeViewer.highlightOnHover((Component)block2, (String)"VaadinServiceInitListenerImpl.java#setConcurrentDownloadTimeout");
        exporter.setConcurrentDownloadCost(9.0f);
        exporter.setDisableOnClick(true);
    }
}

